library(ggplot2)
library(dplyr)
library(lubridate)
library(coda)
library(plotly)
library(psych)

analise_por_variavel<-function(dados) {
  #dados<- bd %>%  filter(INDICADOR=="resultadooperacaopecuaria_rs_hase")
  tryCatch({
    as.numeric(dados$VALOR)->VALOR  
  }, error=function(e){
    stop("Não foi possível converter a variável para tipo numérico.")
  })
  
  hpd<-list()
  hpd[[1]]<-NA
  hpd[[2]]<-NA


  tryCatch({
    hpd<-suppressWarnings(HPDinterval(obj = as.mcmc(na.omit(VALOR)),prob = .9))  
  }, error=function(e){
 })

  describeBy(VALOR,digits = 3)->descritiva
  ks<-NA
  try({
   ks.test(VALOR,"pnorm")$p.value->ks  
  })
  return(as_tibble(descritiva) %>% 
           bind_cols(hpd_l=hpd[[1]],hpd_u=hpd[[2]],ks=ks))
}

descritiva_graficos <- function(dados,grupo) {
  #dados<- bd %>%  filter(INDICADOR=="resultadooperacaopecuaria_rs_hase")
  #variavel<-"resultadooperacaopecuaria_rs_hase"
  #grupo<-"safra"

  tryCatch({
    as.numeric(dados$VALOR)->dados$VALOR
  }, error=function(e){
    stop("Não foi possível converter a variável para tipo numérico.")
  })

  hpd<-suppressWarnings(HPDinterval(obj = as.mcmc(na.omit(dados$VALOR)),prob = .9))

  if(!is.null(grupo)){
    if(grupo=="n_agrupado"){

      p1<-ggplot(dados,aes_string(x="VALOR"))+
        geom_histogram(aes(y = ..density..))+
        geom_density(color='red',fill='red',alpha=.3)+
        theme_minimal()+ xlab("")+ylab("")
      p1+geom_vline(xintercept=as.numeric(hpd),lty=2)->p1
      p2<-ggplot(dados,aes_string(y="VALOR",x=1))+
        geom_boxplot()+
        theme_minimal()+ylab("")+xlab("")
    } else {

     # browser()
      p1<-ggplot(dados,aes_string(x="VALOR",fill=grupo))+
        # geom_histogram(aes(y = ..density..))+
        geom_density(alpha=.3)+
        theme_minimal()+ xlab("")+ylab("")
      p2<-ggplot(dados,aes_string(y="VALOR",x=grupo,fill=grupo))+
        geom_boxplot()+
        theme_minimal()+ylab("")+xlab("")
    }
  }

  # ggplotly(p1,width = "900")->p
  # ggplotly(p2,width = "900")->p2
  return(list(densidade=p1,boxplot=p2))
}

gen_lollipop <- function(dados, saf, franq, yvar) {
  
  if(!is.null(franq)){
    if(franq != 622) {
      dados <- dados %>% 
        filter(as.numeric(id_franquia) == franq)
    }  
  }

  dados %>% 
    filter(ifelse(saf == "Todas", T, safra == saf)) %>%
    group_by(safra) %>%
    mutate(avg = mean(VALOR, na.rm=T),
           acima = ifelse(VALOR > avg, "ACIMA","ABAIXO")
    ) %>% 
    group_by(nome) %>% 
    mutate(avg_faz = mean(VALOR, na.rm=T)) %>% 
    arrange(avg_faz) %>% 
    ungroup %>% 
    mutate(nome = factor(nome, levels = unique(.$nome))) %>% 
    ggplot(aes(x = VALOR, y = nome, col=acima, shape=safra))+
    geom_segment(aes(x=avg, y=nome, xend = VALOR, yend = nome),color='grey50')+
    geom_point()+
    ylab("")+xlab(yvar)+labs(col = NULL, shape = NULL)
}

descrever<-function(bd,variavel,agrupamento){
  if(agrupamento=="n_agrupado"){
    resp<-bd %>% 
      filter(INDICADOR==variavel) %>% 
      do(analise_por_variavel(.)) %>% 
      select(-vars)
  } else {
    resp<-bd %>% 
      group_by_(agrupamento) %>% 
      filter(INDICADOR==variavel) %>% 
      do(analise_por_variavel(.)) %>% 
      select(-vars)
  }

  return(resp)

}





descrever_geral<-function(bd){

  

  resp<-bd %>% 

    split(.$INDICADOR) %>% 

    map(~analise_por_variavel(.))

  

  lapply(names(resp),function(x){resp[[x]]$vars<-x; return(resp[[x]])})->resp

  do.call("rbind",resp)->resp

  resp %>% rename(Indicador=vars)->resp

  

  return(resp)

}



gen_map<-function(variavel,map1){

  map1 %>%

    select(lon,lat,nome,variavel=variavel) %>%

    filter(complete.cases(.)) %>% 

    mutate(lon=round(lon,2),lat=round(lat,2)) %>% 

    mutate(respclass=

             cut(variavel,c(min(variavel,na.rm=T),quantile(variavel,na.rm = T,probs = c(0.25,.5,.75,.9)),max(variavel)),include.lowest = T,dig.lab = 5)) %>% 

    mutate()->map2

  

  

  

  plot_mapbox(type="scattermapbox",colors=c('#a5c86d','#dee774','#f7d96f','#f78c6f')) %>% 

    add_markers(

      data = map2, x = ~lon, y = ~lat,color=~respclass,

      size=~map2$variavel,

      hovertext = round(map2$variavel,3) , alpha = 0.9) %>%

    layout(

      mapbox = list(style = 'light',

                    zoom = 2.5,

                    # plot_bgcolor = '#191A1A', paper_bgcolor = '#191A1A',

                    center = list(lat = ~median(map1$lat),

                                  lon = ~median(map1$lon))),

      legend = list(orientation = 'h',

                    font = list(size = 8)),

      margin = list(l = 25, r = 25,

                    b = 25, t = 25,

                    pad = 2)

    )->p1

  

  return(p1)

}

