library(shiny)
library(DT)
library(readr)
library(tidyr)
library(dplyr)
library(purrr)
library(shinyBS)
library(magrittr)
library(shinyjs)
library(shinyBS)
library(httr)
library(jsonlite)
library(readxl)
source("descritiva.R")
source("log.R")
# options(shiny.reactlog=TRUE)

logwriter = get_log_writer('descritiva')

go_login <- function(redirect_url, session){
  
  if(session$clientData$url_port != "") {
    port <- paste0(":", session$clientData$url_port)
  } else {
    port <- ""
  }
  
  redirect_url <- paste0(session$clientData$url_protocol, "//", session$clientData$url_hostname, port, session$clientData$url_pathname)
  
  runjs(
    paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
  )  
}

get_url <- function(url,token){
  # set_config(config(ssl_verifypeer = 0L))
  return(content(GET(url = url,add_headers(Authorization =  paste0("Bearer ",token))),as = 'text'))
}

get_user <- function(token){
  get_url(url='https://www.inttegra.com/api/usuario',token=token)
}

AuthCode <- function(session){
  pars <- parseQueryString(session$clientData$url_search)
  if(length(pars$token) > 0){
    return(pars$token)
  }
}

shinyServer(function(input, output,session) {
  
  acesso<-reactiveValues()
  acesso[['permissao']] <- F#Sysgetenv("APPS_INTTEGRA_DEVELOPMENT") != ""
  logon_info<-reactiveValues()
  
   ## ao encerrar a sessão salva dados de usuário senão for nullo
  shiny::onSessionEnded(function(){
    tout <- get_date_time()
    #browser()
    if(isolate(acesso[['permissao']]) == T && !is.null(isolate(logon_info[['usuario']])) ){
      
      write.table(isolate({
        list(
          nome =  ifelse(is.null(logon_info$usuario$nome), "", logon_info$usuario$nome),
          franquia = ifelse(is.null(logon_info$usuario$franquia), "", logon_info$usuario$franquia), 
          id_franquia = ifelse(is.null(logon_info$usuario$id_franquia), "", logon_info$usuario$id_franquia), 
          email = ifelse(is.null(logon_info$usuario$email),"",logon_info$usuario$email),
          logindate = logon_info$login$data, logintime = logon_info$login$hora,
          logoutdate = tout$data, logouttime = tout$hora
        )
      }), file=paste0("log/descritiva",format(Sys.Date(), "%Y"),".csv"), append = T, col.names = F, row.names=F, sep=";")
      
    }
  })
  
  
 
  observeEvent(session,{
    AuthCode(session)->token
    
    if(!acesso$permissao){
      
      if(is.null(token)){
        
        go_login("descritiva", session)
      
      } else {
        
        tryCatch({
          # usuario<-fromJSON(get_user(token))
          usuario<-fromJSON(system(paste('curl -k -H "Authorization: bearer', token,'" https://www.inttegra.com/api/usuario'), intern=T))
          # alert(usuario)
        },error=function(e){
          runjs(paste("alert('","Erro ao buscar dados do usuário. Contacte o desenvolvedor.","')"))
          stopApp()
        })
        
        if(!is.null(usuario$nome)){
          # runjs("console.log('pegou usuario')")
          acesso[['permissao']] <- T
          logon_info[['usuario']] <- usuario
          logon_info[['login']] <- get_date_time()    
          # alert(logon_info$usuario)
        }
      }
    } else {
      logon_info[['usuario']]<-list(id_franquia="622",nome='Luigi', franquia="TERA", tipo_usuario = 'S')
      logon_info[['login']] <- get_date_time()
    }
    
  })
  
  
  options(shiny.sanitize.errors = T)
  
  
  ### Controle de usuario -----------------------------------------------------
  
  output$tela_geral<-renderUI({
    if(acesso$permissao){
      
      tagList(
        titlePanel("Análise descritiva Inttegra"),
        sidebarLayout(
          uiOutput("sidebar"),
          uiOutput("mainpanel")
        )  
      )
    } else {
      tagList(
        # h1(as.character(usuario$nome)),
        # uiOutput("senha_ui")  
      )
    }
  })
  
  
  ### Carregamento de bancos --------------------------------------------
  banco<-reactiveValues()
  
  load("bd/banco.rData")
  
  # load("bd/sistemaChoices.rData")
  
  dados %<>% dplyr::left_join(obs_id_df_sis_ori, by=c("obs_id"))
  
  banco[['bd']]<-dados %>% 
    rename(sistema=`SISTEMA PECUÁRIA`
           ,safra=SAFRA
           ,franqueado=FRANQUEADO
           ,estado=ESTADO
           ,nome=`NOME DA FAZENDA`
           ,pastoconf=`PASTO/CONFINAMENTO`
           ,agricultura=`AGRICULTURA PROPRIA  (COM/SEM)`
           ,bioma = BIOMA
    ) %>% 
    mutate(VALOR = as.numeric(VALOR)) %>% 
    left_join(
      read_xlsx(
        'bd/franqueados.xlsx',1
      )
    ) %>% mutate(sistema = gsub(pattern = 'CRE, COM COMPRAS', replacement = 'CRIA-RECRIA-ENGORDA', sistema))
  
  banco[['ind_top']] <- read_xlsx("bd/ind_top.xlsx")
  
  banco[['correcao']] <- read_xlsx("bd/correcao_anual.xlsx")
  
  
  
  ### Filtros --------------------------------------------------------------------------------
  
  output$sidebar <- renderUI({
    if(!is.null(logon_info$usuario)){
      sidebarPanel(width = "3",
                   h3("Filtros"),
                   selectInput("sistema","Sistema",choices=c("Todos",sort(unique(banco$bd$sistemaChoices))),selected = "Todos",multiple = T),
                   selectInput("safra","Safra",choices=c("Todas",sort(unique(banco$bd$safra))),selected = "Todas",multiple = T),
                   if(is.null(logon_info$usuario$id_franquia)||as.numeric(logon_info$usuario$id_franquia)==622){
                     selectInput("franqueado","Franqueado",choices=c("Todos",sort(unique(banco$bd$franqueado))),selected = "Todos",multiple = T,selectize = T)  
                   } else {
                     selectInput(
                       "franqueado","Franqueado"
                       ,choices=
                         c(
                           "Todos",
                           sort(unique(banco$bd %>% filter(as.numeric(id_franquia)==as.numeric(logon_info$usuario$id_franquia)) %>% pull(franqueado)))
                         )
                       ,selected = "Todos"
                       ,multiple = T
                       ,selectize = T
                     )  
                   },
                   selectInput("estado","Estado/País",choices=c("Todos",sort(unique(banco$bd$estado))),selected = "Todos",multiple = T),
                   if(is.null(logon_info$usuario$id_franquia)||as.numeric(logon_info$usuario$id_franquia)==622){
                     selectInput("nome","Fazenda/Grupo",choices=c("Todos",sort(unique(banco$bd$nome))),selected = "Todos",multiple = T)
                   } else {
                     selectInput("nome","Fazenda/Grupo",choices=c("Todos",
                                                                  sort(unique(banco$bd %>% filter(as.numeric(id_franquia) == as.numeric(logon_info$usuario$id_franquia)) %>% pull(nome))))
                                 ,selected = "Todos", multiple = T)
                   },
                   selectInput("pastoconf","Com ou sem confinamento",choices=c("Todos",sort(unique(banco$bd$pastoconf))),selected = "Todos",multiple = T),
                   selectInput("agricultura","Agricultura",choices=c("Todos",sort(unique(banco$bd$agricultura))),selected = "Todos",multiple = T),
                   checkboxInput(inputId = 'corrigir', label = "Corrigir valores, IPCA", value = T),
                   actionButton("filtrar","Iniciar/Filtrar")
      )  
    }
  })
  
  observe({
    if ("Todos" %in% input$sistema) {
      if(which(input$sistema=="Todos")==1){
        if(length(input$sistema)>1){
          selected_choices<-setdiff(input$sistema,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "sistema", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todos" %in% input$franqueado) {
      if(which(input$franqueado=="Todos")==1){
        if(length(input$franqueado)>1){
          selected_choices<-setdiff(input$franqueado,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "franqueado", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todas" %in% input$safra) {
      if(which(input$safra=="Todas")==1){
        if(length(input$safra)>1){
          selected_choices<-setdiff(input$safra,"Todas")  
        } else {
          selected_choices<-"Todas"  
        }
      } else {
        selected_choices<-"Todas"
      }
      updateSelectInput(session, "safra", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todos" %in% input$nome) {
      if(which(input$nome=="Todos")==1){
        if(length(input$nome)>1){
          selected_choices<-setdiff(input$nome,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "nome", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todos" %in% input$estado) {
      if(which(input$estado=="Todos")==1){
        if(length(input$estado)>1){
          selected_choices<-setdiff(input$estado,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "estado", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todos" %in% input$agricultura) {
      if(which(input$agricultura=="Todos")==1){
        if(length(input$agricultura)>1){
          selected_choices<-setdiff(input$agricultura,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "agricultura", selected = selected_choices)
    }
  })
  
  observe({
    if ("Todos" %in% input$pastoconf) {
      if(which(input$pastoconf=="Todos")==1){
        if(length(input$pastoconf)>1){
          selected_choices<-setdiff(input$pastoconf,"Todos")  
        } else {
          selected_choices<-"Todos"  
        }
      } else {
        selected_choices<-"Todos"
      }
      updateSelectInput(session, "pastoconf", selected = selected_choices)
    }
  })
  
  filtrar <- reactive({
    
    if(input$corrigir) {
      
      banco[['bd_filtrado']] <- banco$bd %>% 
        left_join(
          banco$ind_top %>% 
            select(INDICADOR, unidade), by = 'INDICADOR'
        ) %>% 
        left_join(
          banco$correcao %>% 
            select(safra = SAFRA, correcao = valor), by = 'safra'
        ) %>% 
        mutate(VALOR = ifelse(unidade != "R$" | is.na(unidade), VALOR, VALOR * correcao))
      
    } else {
      
      banco[['bd_filtrado']] <- banco$bd
      
    }
    
    if(input$sistema!="Todos"){
      banco$bd_filtrado<-banco$bd_filtrado %>% 
        filter(sistemaChoices %in% input$sistema)  
    } 
    
    if(input$safra!="Todas"){
      banco$bd_filtrado<-banco$bd_filtrado %>% 
        filter(safra %in% input$safra) 
    } 
    
    if(!is.null(input$franqueado)){
      if(input$franqueado!="Todos"){
        banco$bd_filtrado<-banco$bd_filtrado %>%
          filter(franqueado %in% input$franqueado)
      }  
    }
    
    
    if(input$estado!="Todos"){
      banco$bd_filtrado<-banco$bd_filtrado %>% 
        filter(estado %in% input$estado) 
    }
    
    if(!is.null(input$nome)){
      if(input$nome!="Todos"){
        banco$bd_filtrado<-banco$bd_filtrado %>%
          filter(nome %in% input$nome)
      }  
    }
    
    
    if(input$agricultura!="Todos"){
      banco$bd_filtrado<-banco$bd_filtrado %>% 
        filter(agricultura %in% input$agricultura) 
    }
    
    if(input$pastoconf!="Todos"){
      banco$bd_filtrado<-banco$bd_filtrado %>% 
        filter(pastoconf %in% input$pastoconf) 
    }
  })
  
  observeEvent(input$filtrar,{
    filtrar()
  })
  
  
  
  ### Mapas -----------------------------------------------------------
  
  # output$map_select<-renderUI({
  #   banco$bd_filtrado %>% 
  #     dplyr::select(INDICADOR,label) %>% 
  #     distinct() %>% 
  #     filter(INDICADOR %in% names(banco$map1)[-c(1:17)])->opcoes
  #   
  #   as.list(opcoes$INDICADOR)->opcoes_list
  #   names(opcoes_list)<-opcoes$label
  #   
  #   selectInput('map_var_sel',label = 'Vari?vel',choices = opcoes_list)
  # })
  # 
  # output$maps<-renderPlotly({
  #   if(!is.null(input$map_var_sel)){
  #     gen_map(variavel = input$map_var_sel,banco$map1)  
  #   } else {
  #     ggplotly(ggplot())
  #   }
  # })
  
  
  ### Controle de variaveis -----------------------------------------------
  output$var_control <- renderUI({
    # input$filtrar
    if(!is.null(banco$bd)){
      banco$bd -> bd
      
      choices_vd <- bd %>% select(INDICADOR) %>% distinct %>% pull %>% sort
      
      if(is.null(logon_info$usuario$id_franquia)||as.numeric(logon_info$usuario$id_franquia)==622){
        choices_ind <- list("Não agrupado" = "n_agrupado") %>% 
          c(`AGRICULTURA PROPRIA  (COM/SEM)`='agricultura'
            ,ESTADO='estado'
            ,FRANQUEADO='franqueado'
            ,`PASTO/CONFINAMENTO`='pastoconf'
            ,SAFRA='safra'
            ,`SISTEMA PECUÁRIA`='sistema',
            BIOMA = 'bioma')  
      } else {
        choices_ind <- list("Não agrupado" = "n_agrupado") %>% 
          c(`AGRICULTURA PROPRIA  (COM/SEM)`='agricultura'
            ,ESTADO='estado'
            ,`PASTO/CONFINAMENTO`='pastoconf'
            ,SAFRA='safra'
            ,`SISTEMA PECUÁRIA`='sistema'
            ,BIOMA = 'bioma')
      }
      
      
      fluidPage(
        column(6,
               selectInput("var_dependente", label = "Resposta", choices = as.list(choices_vd))
        ),
        column(6,
               selectInput("var_independente", 
                           label = "por",
                           choices = choices_ind
               )
        )  
      )
    }
    
  })
  
  output$var_control2 <- renderUI({
    # input$filtrar
    if(!is.null(banco$bd)){
      
      banco$bd -> bd
      
      choices_vd<-bd %>% select(INDICADOR) %>% distinct %>% pull %>% sort
      
      fluidPage(
        column(6,
               selectInput("var_dependente2",label = "Resposta",choices = as.list(choices_vd))
        )  
      )
    }
    
  })
  
  ### Graficos ------------------------------------------------------------
  
  output$densidade <- renderPlotly({
    if(!is.null(input$var_dependente)){
      
      banco$bd_filtrado %>% filter(INDICADOR==input$var_dependente) -> df_analise
      
      if(nrow(df_analise) > 0 ) {
        descritiva_graficos(dados = df_analise , grupo = input$var_independente)->graficos
        graficos$densidade->p
        ggplotly(p)  
      }
      
    }
  })
  
  output$boxplot <- renderPlotly({
    if(!is.null(input$var_dependente)){
      
      banco$bd_filtrado %>% filter(INDICADOR==input$var_dependente) -> df_analise
      
      if(nrow(df_analise) > 0 ) {
        descritiva_graficos(dados = df_analise , grupo = input$var_independente)->graficos
        graficos$boxplot->p
        ggplotly(p)  
      }
      
    }
  })
  
  output$lollipop_plot <- renderPlotly ({
    if(!is.null(input$var_dependente2)){
      
      lollisize <- banco$bd_filtrado %>%
        filter(INDICADOR == input$var_dependente2) %>%
        filter(!is.na(VALOR)) %>%
        filter(ifelse(input$safra == "Todas", T, safra == input$safra))
      
      if(!is.null(logon_info$usuario$id_franquia)){
        if(logon_info$usuario$id_franquia != 622) {
          lollisize<-lollisize %>%
            filter(as.numeric(id_franquia) == logon_info$usuario$id_franquia) 
        }
      }
      
      lollisize %>% 
        count -> lollisize
      
      
      if(lollisize < 2) {
        NULL
      } else {
        gen_lollipop(banco$bd_filtrado %>% filter(INDICADOR==input$var_dependente2), saf = input$safra, franq = logon_info$usuario$id_franquia, yvar = input$vardependente)->p3
        
        lollisize <- ifelse(as.numeric(lollisize)<25, 25, as.numeric(lollisize))
        
        ggplotly(p3,height = lollisize*15)  
      }
    }
  })
  
  
  ### Tabelas --------------------------------------------------------------
  output$tabela <- renderDataTable({
    descrever(bd = banco$bd_filtrado,variavel = input$var_dependente,agrupamento = input$var_independente)->resp
    
    datatable(resp %>% 
                mutate(cv = sd/mean * 100) %>% 
                mutate_if(is.numeric,round,4) %>% 
                select(1,n=n,Média=mean,Mediana=median,Min=min,Max=max, Skew=skew,Kurstosis=kurtosis,sem=se,sd=sd, `CV (%)` = cv, hpd_l=hpd_l,hpd_u=hpd_u,ks) 
              ,rownames = F
              ,extensions = c("Buttons","Responsive")
              ,selection = list(mode="none")
              ,options = list(dom="Brtp"
                              ,buttons=c('copy', 'csv', 'excel','print')
              )
    )
    
  })
  
  output$report_geral <- renderDataTable({
    
    if(!is.null(banco$bd_filtrado)){
      descrever_geral(banco$bd_filtrado)->resp
      
      datatable(resp %>% mutate_if(is.numeric,round,4) %>% select(Indicador,n=n,Média=mean,Mediana=median,Min=min,Max=max, Skew=skew,Kurstosis=kurtosis,sem=se,sd=sd,hpd_l=hpd_l,hpd_u=hpd_u,ks)
                # ,class='compact stripe hover'
                ,rownames = F
                ,extensions = c("Buttons","Responsive")
                ,selection = list(mode="none")
                ,options = list(dom="Bfrt"
                                ,scrollY="400px"
                                ,pageLength=nrow(resp)
                                ,buttons=c('copy', 'csv', 'excel','print')
                )
                
      )
    }
  })
  
  onclick('help1',
          showModal(
            modalDialog(
              title = "Legenda",
              'SEM = erro padrão da média. Quanto menor melhor. Quanto menor, mais posso confiar na média; SD = desvio padrão. Dispersão do indicador. Quanto maior mais instável; KS = quando for menor que 0,05 a curva é normal, quando for maior que 0,05 a curva não é normal; SKEW = taxa de cauda da curva dos dados. Skew positivo, cauda a direita. Skew negativo cauda a esquerda; KURSTOSIS = achatamento da curva dos dados. Kurstosis alta (pico), muitos dados ao redor da média, Kurstosis pequena, dados diferentes da média (achatamento); HDPI e HPDU = intervalo de alta densidade. 90 % dos dados estão aqui. Potencial técnico de mínima e máxima.',footer = NULL,easyClose = T
            )
          )
  )  
  
  
  output$lollipop_table <- renderDataTable({
    if(!is.null(input$var_dependente2)){
      banco$bd_filtrado %>% 
        filter(INDICADOR==input$var_dependente2) -> d1
      
      if(!is.null(logon_info$usuario$id_franquia)){
        if(logon_info$usuario$id_franquia != 622) {
          d1 <- d1 %>% 
            filter(as.numeric(id_franquia) == logon_info$usuario$id_franquia)
        }  
      }
      
      
      d1 %>% 
        filter(ifelse(input$safra == "Todas",T,safra == input$safra)) %>%
        arrange(VALOR) %>% 
        mutate(avg = mean(VALOR, na.rm=T),
               acima = ifelse(VALOR > avg, "ACIMA","ABAIXO"),
               nome = factor(nome, levels = unique(.$nome))
        ) %>% 
        dplyr::select(safra, nome, VALOR, avg, acima)->d1
      
      datatable(d1 %>% mutate_if(is.numeric,round,4)
                ,rownames = F
                ,extensions = c("Buttons","Responsive")
                ,selection = list(mode="none")
                ,options = list(dom="Brtp"
                                ,buttons=c('copy', 'csv', 'excel','print')
                )
      )      
    }
  })
  
  
  ### Tela Relatorio ----------------------------------------------------------
  output$report <- renderUI({
    
    if(!is.null(banco$bd_filtrado)){
      if(!is.null(input$var_dependente)){
       
        fluidPage(
          fluidRow(
            column(12,
                   plotlyOutput("densidade")
            ),
            column(12,
                   plotlyOutput("boxplot")
            ),
            column(12,
                   tags$div(id='desc_table',
                            tags$div(id='help1',
                                     icon('info-circle'),
                                     "Legenda"
                            ),
                            dataTableOutput("tabela")  
                   )
            )
          )
        )
      } 
    }
  })
  
  
  
  #### Tela lollipop -----------------------------------------------------------
  output$lollipop_ui <- renderUI({
    
    
    fluidPage(
      fluidRow(
        h4("Comparativo por fazenda por variável por safra"),
        column(12,
               uiOutput("var_control2")
        ),
        column(12,
               plotlyOutput("lollipop_plot",height = "auto")  
        ),
        column(12,
               dataTableOutput("lollipop_table")
        )
      )
    )
  })
  
  
  #### Tela MainPanel ------------------------------------------------------
  output$mainpanel <- renderUI({
    tagList(
      # if(!is.null(banco$bd_filtrado)){
        mainPanel( id = "tabs",
          tabsetPanel(
            tabPanel("Univariada",
                     uiOutput("var_control"),
                     uiOutput("report")
            ),
            tabPanel("Geral",
                     tags$div(
                       style="padding-top:20px;",
                       dataTableOutput("report_geral")
                     )
                     
            ),
            if(logon_info$usuario$tipo_usuario != "S")
            {tabPanel("Fazendas",
                     uiOutput("lollipop_ui")
            )}
            
            
            #,
            # tabPanel("Mapas",
            #          tags$div(
            #            style="padding-top:20px;",
            #            uiOutput("map_select"),
            #            plotlyOutput('maps',height = "500px")
            #          )
            
            # )
          )
          
        )
      # }
    )
  })
  

  
})


