var margin = ({top: 40, right: 40, bottom: 40, left: 40});
var height = 400, width = 400;


var lineOutBinding = new Shiny.OutputBinding();

$.extend(lineOutBinding, {
    find: function(scope){
      //console.log($(scope).find('.lapicharts'));
      return $(scope).find('.lapicharts-linechart');
    },
    onValueChange: function(el, data){
      if(data === null)
      return;
      //console.log('lapicharts');
      //console.log(data);
      data.series = data.series.reverse();
      var svg = LapiCharts.select('#'+el.id).select('svg');
      var width = LapiCharts.select('#'+el.id).attr('width') || 400;
      var height = LapiCharts.select('#'+el.id).attr('height') || 400;
      svg.call(LapiCharts.lineChart().dados(data).height(height).width(width)); 
    }
});

Shiny.outputBindings.register(lineOutBinding, 'lapiLineChart.OutputBinding');

var groupHorizontalBars = new Shiny.OutputBinding();

$.extend(groupHorizontalBars, {
  find: function(scope){
    //console.log('FIND');
    return $(scope).find('.lapicharts-groupHorizontalBars');
  },
  onValueChange: function(el, data){
    //console.log('groupBars');
    //console.log(data);
    if (data === null) return;
    var div = LapiCharts.select('#'+el.id);
    var chartsWidth = div.attr('chartsWidth') || 300;
    var chartsHeight = div.attr('chartsHeight') || 200;
    div.call(LapiCharts.groupHorizontalBars()
    .chartsDimensions([chartsWidth, chartsHeight]), data);
  }
});

Shiny.outputBindings.register(groupHorizontalBars, 'lapiGroupBars.OutputBinding');

var sparkBars = new Shiny.OutputBinding();

var sparkdata = {
  bt:1,
  ref: [-5,20,12,14,-5,8,-8,2,10,11,-25],
  faz: [20,-10,-12,-10,5,2,12,-10,0,3,25]
};

$.extend(sparkBars, {
  find: function(scope){
    return $(scope).find('.lapicharts-sparkbars');
  },
  onValueChange: function(el, data){
    if (data === null) return;
    // console.log(data);
    var div = LapiCharts.select('#'+el.id);
    var width = div.attr('width') || 200;
    var height = (div.attr('height') || 50); // div.node().getBoundingClientRect().height;
    if(typeof data === 'number')
    div.call(LapiCharts.sparkBars().height(height), sparkdata);
    else
    div.call(LapiCharts.sparkBars().height(height), data);
  }
});

Shiny.outputBindings.register(sparkBars, 'lapicharts.lapiSparksBars');

var sparkLines = new Shiny.OutputBinding();

$.extend(sparkLines, {
  find: function(scope){
    return $(scope).find('.lapicharts-sparklines');
  },
  onValueChange: function(el, data){
    if (data === null) return;
    var div = LapiCharts.select('#'+el.id);
    var width = div.attr('width') || 200;
    var height = (div.attr('height') || 50); // div.node().getBoundingClientRect().height;
    if(typeof data === 'number')
    div.call(LapiCharts.sparkLines().height(height), sparkdata);
    else
    div.call(LapiCharts.sparkLines().height(height), data);
  }
});

Shiny.outputBindings.register(sparkLines, 'lapicharts.lapiSparkLines');

var lapiGauge = new Shiny.OutputBinding();

$.extend(lapiGauge, {
  find: function(scope){
    return $(scope).find('.lapicharts-lapigauge');
  },
  onValueChange: function(el, data){
    if (data === null) return;
    //console.log('Data Gauge');
    console.log(data);
    var div = LapiCharts.select('#'+el.id);
    var width = div.attr('width') || 200;
    var height = (div.attr('height') || 50); 
    div.call(LapiCharts.lapiGauge().width(width).height(height).domain([0,200]), data);
    
  }
});

Shiny.outputBindings.register(lapiGauge, 'lapicharts.lapiLapiGauge');