var maskedInputBinding = new Shiny.InputBinding();

// step ii
$.extend(maskedInputBinding, {

  find: function(scope) {
    return $(scope).find('.lapi-input-mask');
  },

  initialize: function(el){
    let options = {
      reverse:true
    };
    $('.lapi-input-mask').mask("#.##0,00", options);
  },
  
  getValue: function(el) {  
    return $(el).cleanVal() / 100;
  },

  subscribe: function(el, callback) {   
    $(el).on('keyup.textInputBinding input.maskedInputBinding', function(event) {
      callback(true);
    });
    $(el).on('change.maskedInputBinding', function(event) {
      callback(false);
    });
  }
  
});

// step iii
Shiny.inputBindings.register(maskedInputBinding);