#' @import shiny
#' @import glue
#' @import magrittr
#' @import readxl
#' @import tidyr
#' @import dplyr
#' @import ggplot2
#' @import coda
#' @import jsonlite
#' @import tidytidbits
#' @import shinyBS
#' @import shinyjs
#' @import tibble
#' @import purrr
#' @import broom
#' @import RColorBrewer
#' @import knitr
#' @import kableExtra
#' @import htmltools
#' @import HDInterval
#' @import formattable
#' @import shinythemes
#' @import openxlsx

options(scipen = 29)


app_server <- function(input, output, session) {

  #login <- reactiveValues()
  #login$permissao <- F#Sys.getenv("APPS_INTTEGRA_DEVELOPMENT") != ""
  #logon_info <- reactiveValues()
  
  configuracoes <- reactiveValues(
    processar = NULL,
    fazenda_sel = NULL,
    agrupamento = NULL,
    intra_franquia = 'n',
    historico_variavel = 83,
    metricas_line_chart = c("Fazenda", "Mediana", "Média", "Top-rentáveis", "Potencial", 'Top25', 'Top75')
  )
  
  acao <- reactive({
    if (!is.null(configuracoes$fazenda_sel)) {
      configuracoes$fazenda_sel
    }else{
      NULL 
    }
  })
  
  banco <- reactiveValues(
    processar = 0
  )

  login <- mod_autenticacao_server('autenticacao')
  get_data <- callModule(mod_get_data_server, 'get_data', banco, sel_one = configuracoes, historico, qperdeu, configuracoes)
  historico <- callModule(mod_historico_server, "historico", banco, sel_one, get_data, configuracoes)
  sel_one <- callModule(mod_seletores_server, "sel_one", banco, login, conf = configuracoes)
  qperdeu <- callModule(mod_q_perdeu_server, "ropsyves", banco, get_data, configuracoes, sel_one)
  callModule(mod_calcmetas_server, 'calcmeta',  banco, get_data, configuracoes)
  callModule(mod_ciclo_completo_server, 'ciclo', banco)
  callModule(mod_bread_crumbs_server, 'bread_perspectiva',configuracoes, banco)
  
  # index -------------------------------------------------------------------
  
  output$index_ui <- renderUI({
    
    uiOutput(mod_autenticacao_ui('autenticacao'))
    if (login$is_logged()) {
      # if(logon_info$usuario$tipo_usuario == 'U'){
        

        navbarPageWithEl(
          title = "Inttegra",
          tabPanel(title = "Análise Retrospectiva", mod_historico_ui('historico')),
          tabPanel(title = "Análise Safra", mod_q_perdeu_ui('ropsyves')),
          tabPanel(title = 'Análise Prospectiva',
                          tags$div(class = "container-fluid", style = "margin-top:50px", 
                                   tags$div(style = "padding:7px; float:right;", mod_bread_crumbs_ui('bread_perspectiva')),
                                   tabsetPanel(type = 'tabs', 
                                               tabPanel(title = "Engorda", mod_calcmetas_ui('calcmeta')),
                                               tabPanel(title = "Ciclo completo", mod_ciclo_completo_ui('ciclo'))
                                   )
                          )
                          
          ), 
          el = mod_seletores_ui("sel_one")
        )
      # } else {
      #   navbarPageWithEl(
      #     title="Inttegra",
      #     tabPanel(title = "Análise Retrospectiva", mod_historico_ui('historico')),
      #     tabPanel(title = "Análise Safra", mod_q_perdeu_ui('ropsyves')),
      #     el = mod_seletores_ui("sel_one")
      #   )
      # }
      
      
    } else {
      h4("Acesso não permitido.")
    }
  })
  
  # hideTab
  
}
