#list(tipo="login", app = "farmview", id_franquia="622",nome='Luigi', franquia="TERRA", horario = Sys.time() ) 

#library(yaml)

get_date_time <- function(){
  agora <- as.POSIXlt(Sys.time(), tz="America/Sao_Paulo")
  return(list(data = format(agora, "%e/%m/%Y"), hora=format(agora, "%T")))
}

get_log_writer <- function(filePath = NULL){
    print(paste0("filePath=",filePath))
    arquivo <- NULL
    tryCatch({
      arquivo <- paste0("log/",filePath,format(Sys.Date(), "%m%Y"),".csv")
    }, error = function(err){
      message("É necessário definir parâmetro filePath ou ")
      message("um arquivo de configurações simplelog-conf.yml")
      message(err)
    }, finally = function(){
      f <- function(dados){
        print("Log impresso em tela por falta de definição de arquivo.")
        print(dados)
      }
    })
    
    writer <- function(dados){
      tryCatch({
          write.table(dados, file = arquivo, append = T,
                      col.names = F, sep = ";", row.names = NA)
      }, error = function(err){
        message(err)
      })
    }

    return(writer)
}
