# Module UI
  
#' @title   mod_autenticacao_ui and mod_autenticacao_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_autenticacao
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_autenticacao_ui <- function(id){
  ns <- NS(id)
}



# Module Server
    
#' @rdname mod_autenticacao
#' @export
#' @keywords internal
#' 
#' 
#' 
#' 
    
#source("check_user.R")
#acesso <- reactiveValues()
#acesso[['permissao']] <- F#Sys.getenv("APPS_INTTEGRA_DEVELOPMENT") != ""

#logon_info<-reactiveValues()

#' @export
mod_autenticacao_server <- function(id, testing = F){
  
  #shiny::onSessionEnded(fim_de_sessao(log_file_path))
  
  shiny::moduleServer(id, function(input, output, session){
    
    acesso <- reactiveValues()
    acesso[['permissao']] <- F#Sys.getenv("APPS_INTTEGRA_DEVELOPMENT") != ""
    logon_info<-reactiveValues()
    
    is_logged <- function()isolate(isolate(acesso[['permissao']]) == T && !is.null(isolate(logon_info[['usuario']])))
  
    # go_login <- function(redirect_url, session){
    #   if(session$clientData$url_port != "") {
    #     port <- paste0(":", session$clientData$url_port)
    #   } else {
    #     port <- ""
    #   }
    # 
    #   redirect_url <- paste0(session$clientData$url_protocol, "//", session$clientData$url_hostname, port, session$clientData$url_pathname)
    # 
    #   runjs(
    #     paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
    #   )
    # }

    go_login <- function(port, hostname, protocol, pathname){
      
      if(!is.null(port)) {
        port <- paste0(":", port)
      } else {
        port <- ""
      }
      
      redirect_url <- paste0(protocol, "//", hostname, port, pathname)
      
      runjs(
        paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
      )
    }
    get_url <- function(url,token){
      # set_config(config(ssl_verifypeer = 0L))
      return(content(GET(url = url,add_headers(Authorization =  paste0("Bearer ",token))),as = 'text'))
    }

    get_user <- function(token){
      get_url(url='https://www.inttegra.com/api/usuario',token=token)
    }

    AuthCode <- function(session){
      pars <- parseQueryString(isolate(session$clientData$url_search))
      if(length(pars$token) > 0){
        return(pars$token)
      }
    }
    
    
    
    if(testing == T){
      acesso[['permissao']]<-T
      usuario <-list(nome='Luigi',id_franquia="1076",franquia='DSM',email="meuemail@servior.com", tipo_usuario="U", cliente = "")
      #usuario<-list(nome='Francys',id_franquia="599",franquia='',email="francys@terradesenvolvimento.com.br", tipo_usuario="UQ", cliente="320")
      #logon_info[['usuario']]
      #usuario<-list(nome='ladislau',id_franquia="634",franquia='',email="ladislau@brangushp.com.br", tipo_usuario="S", cliente="193")
      logon_info[['login']] <- get_date_time()
      
    }else{
      
      token <- AuthCode(session)
      browser()
      if(is.null(token)){
        go_login(isolate(session$clientData$url_port), isolate(session$clientData$url_hostname), 
                 isolate(session$clientData$url_protocol), isolate(session$clientData$url_pathname))#, acesso)
      }
      
      tryCatch({
        usuario<-fromJSON(system(paste('curl -k -H "Authorization: bearer', token,'" https://www.inttegra.com/api/usuario'),intern=T))
      },error=function(e){
        runjs(paste("console.log(",e,")"))
        runjs(paste("alert('","Erro ao buscar dados do usuário. Contacte o desenvolvedor.","')"))
        stopApp()
      })
      
    }
    
    # checando se usuário é válido
    if(!is.null(usuario$nome)){
      
      # Se o usuario não do tipo U recuperar cli_codigo e fazendas permitidas
      
     
        # browser()
      #import::from(.from = './R/user_queries.R', .library = 'get_user_data')
      tryCatch({
        usuario <- get_user_data(usuario)}, error = function(err){print(err)})
     
      acesso[['permissao']]<-T
      
      logon_info[['usuario']]<-usuario
      ### Log
      logon_info[['login']] <- get_date_time()
      
    }
    
    
    
    
    
  
  
    
    return(list("logon_info" = logon_info, "is_logged" = is_logged))
  })
}

# 
# mod_autenticacao_server <- function(input, output, session, login, logon_info){
#   logwriter <- get_log_writer('farmview')
#   ns <- session$ns
#   
#    ## ao encerrar a sessão salva dados de usuário senão for nullo
#   shiny::onSessionEnded(function(){
#     tout <- get_date_time()
#     #browser()
#     if(isolate(login[['permissao']]) == T && !is.null(isolate(logon_info[['usuario']])) ){
#       write.table(isolate({
#         list(
#           nome =  ifelse(is.null(logon_info$usuario$nome), "", logon_info$usuario$nome), 
#           franquia = ifelse(is.null(logon_info$usuario$franquia), "", logon_info$usuario$franquia), 
#           id_franquia = ifelse(is.null(logon_info$usuario$id_franquia), "", logon_info$usuario$id_franquia), 
#           email = ifelse(is.null(logon_info$usuario$email),"",logon_info$usuario$email),
#           logindate = logon_info$login$data, logintime = logon_info$login$hora,
#           logoutdate = tout$data, logouttime = tout$hora
#         )
#       }), file=paste0("log/farmview",format(Sys.Date(), "%Y"),".csv"), append = T, col.names = F, row.names=F, sep=";")
#       
#     }
#   })
#  
#   go_login <- function(redirect_url, session){
#     
#     if(session$clientData$url_port != "") {
#       port <- paste0(":", session$clientData$url_port)
#     } else {
#       port <- ""
#     }
#     
#     redirect_url <- paste0(session$clientData$url_protocol, "//", session$clientData$url_hostname, port, session$clientData$url_pathname)
#     
#     runjs(
#       paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
#     )  
#   }
#   
#   get_url <- function(url,token){
#     # set_config(config(ssl_verifypeer = 0L))
#     return(content(GET(url = url,add_headers(Authorization =  paste0("Bearer ",token))),as = 'text'))
#   }
#   
#   get_user <- function(token){
#     get_url(url='https://www.inttegra.com/api/usuario',token=token)
#   }
#   
#   AuthCode <- function(session){
#     pars <- parseQueryString(session$clientData$url_search)
#     if(length(pars$token) > 0){
#       return(pars$token)
#     }
#   }
#   
#   observeEvent(session, {
#     AuthCode(session) -> token
#     if(!login$permissao){
#       if(is.null(token)){
#         go_login("farmview", session)
#       } else {
#         
#         tryCatch({
#           usuario<-fromJSON(system(paste('curl -k -H "Authorization: bearer', token,'" https://www.inttegra.com/api/usuario'),intern=T))
#           
#         },error=function(e){
#           runjs(paste("alert('","Erro ao buscar dados do usuário. Contacte o desenvolvedor.","')"))
#           stopApp()
#         })
#         
#         if(!is.null(usuario$nome)){
#           login[['permissao']] <- T
#           logon_info[['usuario']] <- usuario
#          
#           #########
#           logon_info[['login']] <- get_date_time()
#         }
#       }
#     } else {
#       logon_info[['usuario']] <- list(id_franquia="622",nome='Luigi', franquia="TERRA", tipo_usuario = 'U') #1076 DSM
#       logon_info[['login']] <- get_date_time()
#     }
#     
#   })
#   
# }
#     
# ## To be copied in the UI
# # mod_autenticacao_ui("autenticacao_ui_1")
#     
# ## To be copied in the server
# # callModule(mod_autenticacao_server, "autenticacao_ui_1")
#  
