# Requisitos 
# Arquivos necessários:
# + d/banco.rData
# +
#

library(readxl)
library(dplyr)
library(magrittr)
library(tidyr)
library(coda)
source('R/utils.R')
source('R/calc_regua.R')

carregarDados <- function(bd = NULL, indtop = NULL, franqueados = NULL, cluster = NULL){ 
  banco <- list()
  banco[['ind_top']] <- read_xlsx(indtop) #'../../../ind_top_old.xlsx')
  load(bd) #'bd/banco.rData')
  
  banco[['bd']] <- dados %>% ## return
    dplyr::rename(sistema = `SISTEMA PECUÁRIA`
                  ,safra = SAFRA
                  ,franqueado = FRANQUEADO
                  ,estado = ESTADO
                  ,nome = `NOME DA FAZENDA`
                  ,pastoconf = `PASTO/CONFINAMENTO`
                  ,agricultura = `AGRICULTURA PROPRIA  (COM/SEM)`
    ) %>%
    mutate(franqueado = if_else(franqueado == 1, 'TERRA', franqueado)) %>% 
    left_join(
      readxl::read_xlsx(
        franqueados, 1 #'../../../franqueados_old.xlsx'
      )
    )
  
  banco$bd %<>% 
    filter(!is.na(VALOR)) %>% 
    #mutate(VALOR = gsub("\\D+",  NA, VALOR)) %>% 
    mutate(VALOR =  as.numeric(VALOR)) 
  
  
  #banco$ref %>% 
  banco$bd %>% 
    filter(INDICADOR == "RESULTADO OPERAÇÃO PECUÁRIA (R$/HA) SE") %>% 
    group_by(safra) %>% 
    mutate(
      top30 = quantile(VALOR,probs = c(.7)),
      ref = ifelse(VALOR > top30, 1, 0)
    ) %>% 
    dplyr::select(TÉCNICO, franqueado, safra, nome, MUNICÍPIO, top30, ref) -> ref
  
  banco$bd %>%
    left_join(
      banco$bd %>%
        count(franqueado, nome, FRENTE, INDICADOR), by = c('franqueado', 'nome', 'FRENTE', 'INDICADOR')
    ) %>% 
    filter(n > 1) %>% 
    select(nome, safra, franqueado,id_franquia) %>%
    distinct() %>%
    group_by(nome,franqueado,id_franquia) %>%
    summarise(n = n()) %>%
    ungroup %>%
    mutate(faz_id = 1:nrow(.)) -> banco[['faz_id_data']]  ## return
   
  banco$bd %<>%
    left_join(
      banco$faz_id_data %>% select(nome, franqueado, faz_id), by = c('nome', 'franqueado')
    )
  
  banco$ref <- banco$bd
  return(banco)
}


processarReguas <- function(b, sis = NULL){
  
  if(!is.null(sis)){
    b$ref <- b$bd %>%  filter(sistema == sis)
  }
  
  b$ref %>% 
    filter(INDICADOR == "RESULTADO OPERAÇÃO PECUÁRIA (R$/HA) SE") %>% 
    group_by(safra) %>% 
    mutate(
      top30 = quantile(VALOR,probs = c(.7)),
      ref = ifelse(VALOR > top30, 1, 0)
    ) %>% 
    dplyr::select(TÉCNICO, franqueado, safra, nome, MUNICÍPIO, top30, ref) -> ref
  
  b$ref %>% 
    filter(FRENTE != "REPRODUÇÃO") %>% 
    bind_rows(
      b$ref %>% 
        filter(FRENTE == "REPRODUÇÃO") %>% 
        mutate(safra_ref = ifelse(FRENTE == "REPRODUÇÃO", stringr::str_extract(INDICADOR,"\\d\\d.\\d\\d"), NA)) %>% 
        mutate(ano1 = ifelse(!is.na(safra_ref), as.numeric(stringr::str_extract(safra_ref, "\\d\\d")), NA)) %>% 
        mutate(INDICADOR = ifelse(FRENTE == "REPRODUÇÃO", gsub("\\(SF([^\\)]+)\\)","", INDICADOR), INDICADOR)) %>% 
        mutate(INDICADOR = ifelse(FRENTE == "REPRODUÇÃO", gsub("SF(.*)","", INDICADOR), INDICADOR)) %>%
        mutate(INDICADOR = trimws(INDICADOR, which  = "both")) %>% 
        arrange(INDICADOR, ano1) %>% 
        group_by(INDICADOR) %>% 
        filter(ano1 == last(ano1) | is.na(ano1))
    ) %>% 
    left_join(
      ref, by = c("TÉCNICO", "franqueado", "safra", "nome")
    ) %>% 
    right_join(
      b$ind_top, by = c("FRENTE", "INDICADOR")
    ) %>% 
    group_by(INDICADOR, safra, FRENTE, TOP) %>% 
    nest %>% 
    mutate(regua = purrr::pmap(.l=list(data, top = TOP), .f = calc_regua)) %>% 
    unnest(regua) %>% 
    arrange(safra, FRENTE, INDICADOR) -> regua
    regua %>% ungroup
}

# a <- carregarDados( bd = 'bd/banco.rData', indtop = '../../ind_top_old.xlsx',
#                     franqueados = '../../franqueados_old.xlsx')
# 
# 
# #todos
# rTodasOld <- processarReguas(a)
# #CRIA
# rCOld <- processarReguas(a, sis = "CRIA")
# #CRIA-RECRIA-ENGORDA
# rCREOld <- processarReguas(a, sis = "CRIA-RECRIA-ENGORDA")
# #RECRIA-ENGORDA
# rREOld <- processarReguas(a, sis = "RECRIA-ENGORDA")
# 
# load('bd/reguaTodas.rData')
# 


### DESCOMENTAR PARA SALVAR REGUAS

# b <- carregarDados( bd = 'bd/banco.rData', indtop = 'bd/ind_top.xlsx',
#                     franqueados = 'bd/franqueados.xlsx')
# 
# 
# #todos
# reguaTodas <- processarReguas(b)
# save(reguaTodas, file="bd/reguaTodas.rData")
# #CRIA
# reguaCria <- processarReguas(b, sis = "CRIA")
# save(reguaCria, file="bd/reguaCria.rData")
# #CRIA-RECRIA-ENGORDA
# reguaCompleto <- processarReguas(b, sis = "CRIA-RECRIA-ENGORDA")
# save(reguaCompleto, file="bd/reguaCriaRecriaEngorda.rData")
# #RECRIA-ENGORDA
# reguaRecriaEngorda <- processarReguas(b, sis = "RECRIA-ENGORDA")
# save(reguaRecriaEngorda, file="bd/reguaRecriaEngorda.rData")
# 
# relatorio <- function(coluna, dt, dtt){
#   print(paste("Coluna:", coluna))
#   data.frame(dt == dtt) %>% filter(!is.na(coluna)) %>% table()
# }
# 
# comparar <- function(d_one, d_two, saf){
#   print("-------------------------------------------")
#   print(paste("SAFRA:", saf))
#   d_one %<>% filter(safra == saf)
#   d_two %<>% filter(safra == saf)
#   dplyr::all_equal(  d_one %>% select(safra, min:ref) , d_two %>% select(safra, min:ref) )
# }
# 
# safras <- c("2012/2013", "2013/2014", "2014/2015", "2015/2016", "2016/2017", "2017/2018", "2018/2019", "2019/2020", "2020/2021")
# 
