#import::here('RMySQL')
#import::here('dbx', dbxConnect, dbxDisconnect, dbxSelect)
#import::here('glue', glue)

#' criação de conexão, apenas para simplificar para o programador, não tendo de repetir o código em
#' diferentes pontos.
get_connection <- function(){
  dbx::dbxConnect(host = "mysql.inttegra.com", adapter = "mysql", port = 3306, dbname = "terradesenvolv",
                  user = "web", password = "RnuFdpe3&7g6dWb")
}

#' @title get_user_data
#'
#' @export
get_user_data <- function(usuario){
  tryCatch({
    con <- get_connection()
    usuario[["id_pessoa"]] = get_id_pessoa(con, usuario$email)
    if(usuario$tipo_usuario == "UQ"){
      usuario[["lista_clientes"]] = get_clientes_by_tec(con, usuario$id_pessoa) 
    }
  }, 
  error = function(err){}, 
  finally = {
    dbx::dbxDisconnect(con)  
  })
  return(usuario)
}

#' @title get_id_pessoa
#' Esta função faz uma busca na tabela terra_login_v do banco de dados do SIGA buscando obter o atributo
#' id_pessoa do usuário baseado em seu email.
#' @param user_email tipo string, email do usuario a ser utilizado na busca pelo atributo id_pessoa
#' @return integer
#' 
#' @export
get_id_pessoa <- function(con, user_email){
  tryCatch({
    query <- glue("SELECT * FROM terra_login_v where email = '{user_email}';")
    result <- dbx::dbxSelect(con, query)
  }, error = function(err){
    message(err)
  }, finally = {
    #dbx::dbxDisconnect(con)
  })
  return(result$id_pessoa)
}


#' @title get_clientes_by_tec
#'
#' @param id_pessoa 
#'
#' @return
#' @export
#'
#' @examples
get_clientes_by_tec <- function(con, id_pessoa){
  tryCatch({
    query <- glue("SELECT * FROM terra_pessoa_cliente where id_pessoa = '{id_pessoa}';")
    result <- dbx::dbxSelect(con, query)
  }, error = function(err){
    message(err)
  })
  
  if(length(result$cli_codigo) > 0){
    return(paste(result$cli_codigo, sep = ','))  
  }else{
    return(c())
  }
  
}
