library(dplyr)

#bd de uma das aplicacoes
load(file = 'bd/banco.rData')

save(dados, dados_pvar, dados_wd, obs_id_df_sis_ori, file = "bancoBkP.rData")

cd <- openxlsx::read.xlsx("/home/sfanalise/chaves_producao.xlsx")


chaves <-
  cd %>%
  rename(
    "NOME DA FAZENDA" = NOME.DA.FAZENDA,
    "NOME DA FAZENDA_ORIGINAL" = NOME.DA.FAZENDA_ORIGINAL
  )



chaves_hasheadas <- c("TÉCNICO","FRANQUEADO","NOME DA FAZENDA",
                      "MUNICÍPIO","ESTADO","REGIÃO")

dados_pvar_des <-
  dados_pvar %>% 
  mutate(`NOME DA FAZENDA` = tolower(`NOME DA FAZENDA`)) %>% 
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("TÉCNICO")) %>% dplyr::distinct(), by = 'TÉCNICO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("NOME DA FAZENDA")) %>% dplyr::distinct(), by = 'NOME DA FAZENDA'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("FRANQUEADO")) %>% dplyr::distinct(), by = 'FRANQUEADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("MUNICÍPIO")) %>% dplyr::distinct(), by = 'MUNICÍPIO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("ESTADO")) %>% dplyr::distinct(), by = 'ESTADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("REGIÃO")) %>% dplyr::distinct(), by = 'REGIÃO'
  ) %>%
  dplyr::mutate(
    "TÉCNICO" =         `TÉCNICO_ORIGINAL`,
    "NOME DA FAZENDA" = `NOME DA FAZENDA_ORIGINAL`,
    "FRANQUEADO" =      `FRANQUEADO_ORIGINAL`,
    "MUNICÍPIO" =       `MUNICÍPIO_ORIGINAL`,
    "ESTADO" =          `ESTADO_ORIGINAL`,
    "REGIÃO" =          `REGIÃO_ORIGINAL`
  )  %>%
  dplyr::select(-ends_with('_ORIGINAL'))

dados_wd_des <-
  dados_wd %>%
  mutate(`NOME DA FAZENDA` = tolower(`NOME DA FAZENDA`)) %>% 
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("TÉCNICO")) %>% dplyr::distinct(), by = 'TÉCNICO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("NOME DA FAZENDA")) %>% dplyr::distinct(), by = 'NOME DA FAZENDA'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("FRANQUEADO")) %>% dplyr::distinct(), by = 'FRANQUEADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("MUNICÍPIO")) %>% dplyr::distinct(), by = 'MUNICÍPIO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("ESTADO")) %>% dplyr::distinct() , by = 'ESTADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("REGIÃO")) %>% dplyr::distinct(), by = 'REGIÃO'
  ) %>%
  dplyr::mutate(
    "TÉCNICO" =         `TÉCNICO_ORIGINAL`,
    "NOME DA FAZENDA" = `NOME DA FAZENDA_ORIGINAL`,
    "FRANQUEADO" =      `FRANQUEADO_ORIGINAL`,
    "MUNICÍPIO" =       `MUNICÍPIO_ORIGINAL`,
    "ESTADO" =          `ESTADO_ORIGINAL`,
    "REGIÃO" =          `REGIÃO_ORIGINAL`
  )  %>%
  dplyr::select(-ends_with('_ORIGINAL'))

dados_des <-
  dados %>%
  mutate(`NOME DA FAZENDA` = tolower(`NOME DA FAZENDA`)) %>% 
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("TÉCNICO")) %>% dplyr::distinct(), by = 'TÉCNICO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("NOME DA FAZENDA")) %>% dplyr::distinct(), by = 'NOME DA FAZENDA'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("FRANQUEADO")) %>% dplyr::distinct(), by = 'FRANQUEADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("MUNICÍPIO")) %>% dplyr::distinct(), by = 'MUNICÍPIO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("ESTADO")) %>% dplyr::distinct(), by = 'ESTADO'
  ) %>%
  dplyr::left_join(
    chaves %>% dplyr::select(dplyr::starts_with("REGIÃO")) %>% dplyr::distinct(), by = 'REGIÃO'
  ) %>%
  dplyr::mutate(
    "TÉCNICO" =         `TÉCNICO_ORIGINAL`,
    "NOME DA FAZENDA" = `NOME DA FAZENDA_ORIGINAL`,
    "FRANQUEADO" =      `FRANQUEADO_ORIGINAL`,
    "MUNICÍPIO" =       `MUNICÍPIO_ORIGINAL`,
    "ESTADO" =          `ESTADO_ORIGINAL`,
    "REGIÃO" =          `REGIÃO_ORIGINAL`
  )  %>%
  dplyr::select(-ends_with('_ORIGINAL'))

dados <- dados_des
dados_pvar <- dados_pvar_des
dados_wd <- dados_wd_des

save(dados, dados_pvar, dados_wd, obs_id_df_sis_ori, file = "banco.rData")
