library(dplyr)

#bd de uma das aplicacoes
load(file = 'bd/clusters_all.rData')

save(clusters_all, file = "clusters_all_BkP.rData")

cd <- openxlsx::read.xlsx("/home/sfanalise/chaves_producao.xlsx")


chaves <-
  cd %>%
  select(
    "nome" = NOME.DA.FAZENDA,
    "NOME DA FAZENDA_ORIGINAL" = NOME.DA.FAZENDA_ORIGINAL
  ) %>% unique()


clusters_all_des <-
  clusters_all %>%
  mutate(`nome` = tolower(`nome`)) %>%
  dplyr::left_join(
    chaves , by = 'nome'
  ) %>% 
  dplyr::mutate(
    "nome" = `NOME DA FAZENDA_ORIGINAL`
  ) %>% 
  dplyr::select(-ends_with('_ORIGINAL'))

clusters_all <- clusters_all_des

save(clusters_all, file = "clusters_all.rData")
