infocard <- function(status, tipo, title, texto1, texto2) {
  
  
  colpattern <- status * tipo
  ifelse(colpattern == 1, 'igb', ifelse(colpattern == 0, 'std', 'igw')) -> pattern
  
  tags$div(class= paste('infocard', pattern),
           tags$div(class = 'infocard-iconbox',
                    icon(ifelse(status > 0, 'arrow-up', ifelse(status < 0, 'arrow-down', 'minus')))
           ),
           tags$div(class = 'infocard-textbox',
                    tags$p(title, class = 'title'),
                    tags$p(class = 'maintext',
                           ifelse(status > 0, 
                                  glue('Crescendo a {texto1} por safra'), 
                                  ifelse(status < 0, 
                                         glue('Reduzindo a {texto1} por safra'), 
                                         'Estável ao longo das safras')
                           )
                    )
           )
  )
}


chartcard <- function(title, value, chart, tipo) {
  tags$div(
    class = paste('infocard', tipo),
  fluidPage(
            fluidRow( column(class="chartbox-title", width=12, tags$span(title))),
            fluidRow(class="is-table-row", 
                     column(width=5, class="text-center", style="vertical-align:middle;", tags$p(value, class="infocard-valor")),
                     column(width=7, style="margin:2px; padding:10px; box-sizing:unset; vertical-align:middle;", chart))
  )
  )
  
  # tags$div(class='infocard std',
  #          tags$div(class = 'infocard-chartbox',
  #                   chart),
  #          tags$div(class = 'infocard-textbox',
  #                   tags$p(title, class = 'title'),
  #                   tags$p(class = 'maintext',value)
  #          )
  # )
}