# Module UI

#' @title   mod_historico_ui and mod_historico_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_historico
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_historico_ui <- function(id){
  ns <- NS(id)
  ui <- uiOutput(ns(id))
}

# Module Server

#' @rdname mod_historico
#' @export
#' @keywords internal

mod_historico_server <- function(input, output, session, banco, sel_one, get_data, configuracoes){
  
  ns <- session$ns
  
  callModule(mod_bread_crumbs_server, 'bread_historico', configuracoes, banco)
  
  output$historico <- renderUI({
    
    # if(!is.null(banco$processar)){
    #   if(!is.null(banco$regua)){
    
    fluidPage(
      fluidRow(
        tags$div( class="col-xs-12",
          style = 'margin-top: 26px',
          uiOutput(ns('sel_variavel_ui'))  
        )
      ),
      fluidRow(
        tags$div(
          style = 'margin-bottom: 10px',
          uiOutput(ns('infocards'))
        )
      ),
      fluidRow(
        uiOutput(ns('linechart_ui')),
        tags$div(class="col-xs-12 col-sm-12 col-md-6",
                 uiOutput(ns('bar_chart_ui'))
        )
      ),
      fluidRow(
        column(6,
               tags$div(
                 style = 'padding-left:30px;',
                 uiOutput(ns('comp_table'))
               )
        )
      )
    )
  })
  
  
  
  # seletores ---------------------------------------------------------------
  
  output$sel_variavel_ui <- renderUI({

    get_data$criar_bd_referencia()
    # Este if evita que o processamento de banco$regua aconteça quan banco$regua == NULL
    # evitando mensagem de erro.
    if(is.null(banco$regua)){
      ## É possível colocar alguma mensagem aqui enquanto os dados são processados.
    } else {
    
      get_ind_id <- function(x){
        x %>% select(INDICADOR, variavel_id) %>% split(.$INDICADOR) %>% lapply(., pull, variavel_id)
      }
      
      banco$indicadores %>% 
        split(.$FRENTE) %>% 
        lapply(., get_ind_id) -> choices_ind
      
      fluidPage(
        fluidRow(
          column(6,
                 tags$div(
                   style = 'margin-top:20px; margin-left:-30px;',
                   selectInput(inputId = ns("sel_variavel"), label = "Variável:", 
                               choices = choices_ind, selected = configuracoes$historico_variavel)
                 )
          ),
          tags$div(class="col-xs-12 col-sm-6", style = 'margin-top:26px; text-align:right;', mod_bread_crumbs_ui(ns('bread_historico')))
        )
      )  
    }
    
    
    
  })
  
  observeEvent(input$sel_variavel,{
    
    configuracoes$historico_variavel <- input$sel_variavel
    
  })
  
  output$infocards <- renderUI({
    
    if(!is.null(input$sel_variavel)) {
      # if(sel_one$processar() > 0) {
      if(!is.null(get_data$consolide_safras())){

        get_data$consolide_safras()$stats -> stats
        
        if(any(is.nan(stats$p.value))){
          
          
          
          get_data$consolide_safras()$banco %>% 
            select(safra, Fazenda, Mediana, 'Top-rentáveis', Top75) %>% 
            arrange(safra) %>% 
            summarise_at(2:5, diff) -> comp
          
          val_fazenda <- list(p.value = 0, valor = comp$Fazenda)
          val_cenario_medio <- list(p.value = 0, valor = comp$Mediana)
          val_top_rentaveis <- list(p.value = 0, valor = comp$`Top-rentáveis`)
          val_referencia <- list(p.value = 0, valor = comp$Top75)
          
        } else {
          
          stats %>% filter(key == 'Fazenda') -> dados_fazenda
          stats %>% filter(key == 'Média') -> dados_media
          stats %>% filter(key == 'Top-rentáveis') -> dados_top_rentavel
          stats %>% filter(key == 'q70') -> dados_top30
          
          val_fazenda <- list(p.value = dados_fazenda$p.value, valor = dados_fazenda$coef)
          val_cenario_medio <- list(p.value = dados_media$p.value, valor = dados_media$coef)
          val_top_rentaveis <- list(p.value = dados_top_rentavel$p.value, valor = dados_top_rentavel$coef)
          val_referencia <- list(p.value = dados_top30$p.value, valor = dados_top30$coef)
          
        }
        
        tipo <- ifelse( get_data$consolide_safras()$banco$TOP %>% first == "MAIOR", 1, -1)
        
        banco$ind_top %>% 
          left_join(
            banco$indicadores, by = c("FRENTE", "INDICADOR")
          ) %>% 
          filter(variavel_id == input$sel_variavel) -> var_config
        
        fator <- ifelse(var_config$unidade == "%", 100, 1)
        
        card_fazenda <- tags$div(class="col-xs-12 col-sm-6 col-md-4 col-lg-3",
                                 tagList(infocard(
                                   status = ifelse(val_fazenda$p.value < 0.05, ifelse(val_fazenda$valor > 0, 1, -1), 0),
                                   tipo = tipo,
                                   title = "Fazenda",
                                   texto1 = format(round(val_fazenda$valor*fator, digits = var_config$casas), nsmal = var_config$casas, digits = var_config$casas, decimal.mark = ","), texto2 = 'top mesmo!'
                                 ))
        )
        
        card_cenario_medio <- tags$div(class="col-xs-12 col-sm-6 col-md-4 col-lg-3",
                                       infocard(
                                         status = ifelse(val_cenario_medio$p.value < 0.05, ifelse(val_cenario_medio$valor > 0, 1, -1), 0),
                                         tipo = tipo,
                                         title = "Cenário médio",
                                         texto1 = format(round(val_cenario_medio$valor*fator, digits = var_config$casas), nsmal = var_config$casas, digits = var_config$casas, decimal.mark = ","), texto2 = 'top mesmo!'
                                       ))
        
        
        
        card_top_rentaveis <- tags$div(class="col-xs-12 col-sm-6 col-md-4 col-lg-3",
                                       infocard(
                                         status = ifelse(val_top_rentaveis$p.value < 0.05, ifelse(val_top_rentaveis$valor > 0, 1, -1), 0),
                                         tipo = tipo,
                                         title = "Top-rentáveis",
                                         texto1 = format(round(val_top_rentaveis$valor*fator, digits = var_config$casas), nsmal = var_config$casas, digits = var_config$casas, decimal.mark = ","), texto2 = 'top mesmo!'
                                       ))
        
        card_referencia <- tags$div(class="col-xs-12 col-sm-6 col-md-4 col-lg-3",
                                    infocard(
                                      status = ifelse(val_referencia$p.value < 0.05, ifelse(val_referencia$valor > 0, 1, -1), 0),
                                      tipo = tipo,
                                      title = "Top-indicador",
                                      texto1 = format(round(val_referencia$valor*fator, digits = var_config$casas), nsmal = var_config$casas, digits = var_config$casas, decimal.mark = ","), texto2 = 'top mesmo!'
                                    ))
        
        cards <- tagList(
          card_fazenda, card_cenario_medio, card_top_rentaveis, card_referencia
        )
        
        
        fluidRow(
          column(12,
                 cards
          )
        )
      }
    }
  })
  
  output$linechart_ui <- renderUI ({
    if(!is.null(input$sel_variavel)){
      
      if(!is.null(get_data$consolide_safras())){
        tags$div(class="col-xs-12 col-sm-12 col-md-6", 
                 tags$div(
                   style = 'padding-left:30px; margin-top:30px;',
                   h4("Valores ajustados por safra", style = 'font-weight:600')
                   ,lapiLineChartOutput(ns('line_chart'))
                 )        
        )
      }else{
        tags$div(class="col-xs-12",
                 tags$div( class="alert alert-info", role="alert", style="text-align:center;",
                           icon(name="info-circle"), "Para esta variável não temos dados históricos")
        )
      }
      
    }
  })
  
  output$line_chart <- renderLapiLineChart({
    
    if(!is.null(get_data$consolide_safras())){
      
      get_data$consolide_safras()$banco -> comp_df
      
      ### LINHAS ABAIXO MONTAM OUTPUT PARA FUNCAO LAPIDATA
      ### SE QUISER VER O GRAFICO USANDO RENDERPLOT, COMENTE AS LINHAS ABAIXO ATÉ  O PRÓXIMO COMENTARIO E REMOVA O COMENTÁRIO DA SEÇÃO SEGUINTE.
      
      color_df <- tibble(
        id = c("Fazenda", "Mediana", "Potencial","Top-rentáveis","Média"),
        color = c('#da761d','#6fa12a','#a12a6d','#4c4c4c', '#3b1dda')
      )
      
      color_df %<>% 
        filter(id %in% configuracoes$metricas_line_chart)
      
      banco$ind_top %>% 
        left_join(
          banco$indicadores, by = c("FRENTE", "INDICADOR")
        ) %>% 
        filter(variavel_id == input$sel_variavel) -> var_config
      
      
      
      if(nrow(comp_df) >= 6) {
        comp_df %<>%
          mutate(safra = sapply(lapply(strsplit(safra, '/'), function(x) {as.numeric(x) %% 100}), function(x) paste(x, collapse = '/')))
      }
      
      comp_df %>%
        dplyr::select(-INDICADOR, -FRENTE, -TOP, -unidade, -variavel_id, -data, -ini_simbol, -fim_simbol) %>%
        dplyr::select(safra, configuracoes$metricas_line_chart) %>%
        pivot_longer(c(Fazenda, Mediana, Média, `Top-rentáveis`, Potencial, Top25, Top75), names_to = 'id', values_to = 'y') %>% 
        rename(x = safra) -> d1  
      
      d1 %<>% 
        filter(!is.na(y))
      
      if(var_config$unidade == "%"){
        d1$y <- format(d1$y*100, nsmall = var_config$casas, digits = var_config$casas) %>% as.numeric
      } else {
        d1$y <- format(d1$y, nsmall = var_config$casas, digits = var_config$casas) %>% as.numeric
      }
      
      
      d1 %>%
        group_by(id) %>%
        nest(.key = 'values') %>%
        convert_to_lapichart(title = '',
                             xlab = '',
                             ylab = comp_df$INDICADOR %>% first,
                             unidade = comp_df$unidade %>% first, colors = color_df)
    }
  })
  
  output$bar_chart_ui <- renderUI({
    if(!is.null(input$sel_variavel)){
      
      if(!is.null(get_data$consolide_safras())){
        tags$div( id = ns('grafico_barra_hori'), style = 'padding-right: 30px; margin-top:30px;',
                  h4("Gráficos de barra comparativos", style = 'font-weight:600'),
                  lapiGroupHorizontalBarsOutput(ns('bar_chart'))
        )
      }
      
    }
  })
  
  output$bar_chart <- renderLapiBarChart({
    if(!is.null(get_data$consolide_safras())){
      
      get_data$consolide_safras()$banco -> comp_df
      
      comp_df %>%
        arrange(safra) %>%
        mutate(
          "Própria fazenda" = Fazenda - mean(Fazenda)
        ) %>%
        execute_if_else(
          "Mediana" %in% names(.),
          mutate(Mediana = Fazenda - Mediana),
          mutate(Mediana = NA)
        ) %>%
        execute_if_else(
          'Top-rentáveis' %in% names(.),
          mutate("Top-rentáveis" = Fazenda - `Top-rentáveis`),
          mutate("Top-rentáveis" = NA)
        ) %>%
        execute_if_else(
          'Potencial' %in% names(.),
          mutate(Potencial = Fazenda - Potencial),
          mutate(Potencial = NA)
        ) %>%
        select(safra, TOP,  "Própria fazenda", "Top-rentáveis", "Potencial", Mediana) %>%
        pivot_longer(c("Própria fazenda", "Top-rentáveis", "Potencial", Mediana), names_to = 'key', values_to = 'value') %>% 
        filter(!is.na(value))-> d1
      
      cols <- brewer.pal(n = 5, name = "RdYlGn")
      if(comp_df %>% pull(TOP) %>% first != 'MAIOR'){
        cols <- rev(cols)
      }
      
      comp_df %>% pull(unidade) %>% first -> unidade
      
      banco$ind_top %>% 
        left_join(
          banco$indicadores, by = c("FRENTE", "INDICADOR")
        ) %>% 
        filter(variavel_id == input$sel_variavel) -> var_config
      
      fator <- ifelse(var_config$unidade == "%", 100, 1)
      
      d1 %>%
        rename(y = safra, x = value, id = key) %>%
        mutate(x = format(x*fator, nsmall = var_config$casas, digits = var_config$casas) %>% as.numeric,
               gib=ifelse(TOP=='MAIOR', 1, 0)) %>%
        group_by(id, gib) %>%
        nest(.key = 'values') %>%
        convert_to_lapichart(title = 'Esse é o título',
                             xlab = 'Diferença entre valor por safra e referência', ylab = '', unidade = '%', colors = NULL)
    }
  })
  
  output$comp_table <- renderUI({
    
    if(!is.null(get_data$consolide_safras())){
      
      get_data$consolide_safras()$banco -> comp_df
      
      v1 <- comp_df %>% arrange(safra) %>% pull(Fazenda)
      v2 <- comp_df %>% arrange(safra) %>% pull(Fazenda)
      
      banco$ind_top %>% 
        left_join(
          banco$indicadores, by = c("FRENTE", "INDICADOR")
        ) %>% 
        filter(variavel_id == input$sel_variavel) -> var_config
      
      
      
      comp_top_rentaveis <- "Top-rentáveis" %in% names(comp_df)
      
      if(comp_top_rentaveis) {
        v3 <- comp_df %>% arrange(safra) %>% pull(`Top-rentáveis`)
      } else {
        v3 <- v2
      }
      
      names(v1) <- comp_df$safra %>% sort
      names(v2) <- comp_df$safra %>% sort
      
      matriz_comp <- matrix(nrow = length(v1), ncol = length(v2))
      row.names(matriz_comp) <- comp_df$safra %>% sort
      colnames(matriz_comp) <- comp_df$safra %>% sort
      
      menor <- ifelse(comp_df$TOP %>% first == 'MENOR', 'darkgreen', 'darkred')
      maior <- ifelse(comp_df$TOP %>% first != 'MENOR', 'darkgreen', 'darkred')
      
      for(i in 1:length(v1)) {
        for(j in 1:length(v2)) {
          
          
          if(i > j) {
            val <- v1[i] - v2[j]
            
            if(var_config$unidade == "%"){
              val <- format(round(val*100, digits=var_config$casas), nsmall = var_config$casas, digits = var_config$casas)
            } else {
              val <- format(round(val, digits=var_config$casas), nsmall = var_config$casas, digits = var_config$casas)
            }

            matriz_comp[i,j] <- span(class = 'lowdiag', style = paste0('color:',ifelse(as.numeric(val)<0, menor, maior)), data = paste0('[',round(v1[i],3),',', round(v2[j],3),']') %>% toJSON, val) %>% as.character
          } else {
            
            if(comp_top_rentaveis){
              
              val <- v1[i] - v3[j]
              if(var_config$unidade == "%"){
                val <- format(round(val*100, digits=2), nsmall = var_config$casas, digits = var_config$casas)
              } else {
                val <- format(round(val, digits=var_config$casas), nsmall = var_config$casas, digits = var_config$casas)
              }
              
              matriz_comp[i,j] <- span(class = ifelse(i == j,'updiag diag','updiag'), style = paste0('color:',ifelse(as.numeric(val)<0, menor, maior)), data = paste0('[',v1[i],',', v3[j],']'), val) %>% as.character
              
            } else {
              
              if(i == j) {
                
                val <- v1[i] - v3[j]
                if(var_config$unidade == "%"){
                  val <- format(round(val*100, digits=2), nsmall = var_config$casas, digits = var_config$casas)
                } else {
                  val <- format(round(val, digits=var_config$casas), nsmall = var_config$casas, digits = var_config$casas)
                }
                
                matriz_comp[i,j] <- span(class = 'diag', data = paste0('[',v1[i],',', v3[j],']'), val) %>% as.character
              } else {
                
                val <- v1[i] - v3[j]
                if(var_config$unidade == "%"){
                  val <- format(round(val*100, digits=2), nsmall = var_config$casas, digits = var_config$casas)
                } else {
                  val <- format(round(val, digits=var_config$casas), nsmall = var_config$casas, digits = var_config$casas)
                }
                
                matriz_comp[i,j] <- span(class = 'lowdiag', style = paste0('color:',ifelse(as.numeric(val)<0, menor, maior)), data = paste0('[',v1[i],',', v3[j],']'), val) %>% as.character
                
              }
            }
          }
        }
      }
      
      top_label <- "Referência"
      upper_header <- c(2, length(v1))
      names(upper_header) <- c(" ", top_label)
      
      tagList(
        h4("Quadro comparativo safra a safra", style = 'font-weight:600'),
        HTML(
          matriz_comp %>%
            as.data.frame %>%
            rownames_to_column(var = " ") %>%
            mutate('origem' = cell_spec('Fazenda', angle = 270)) %>%
            .[,c((length(v1)+2),(1:(length(v1)+1)))] %>%
            setNames(., c(" ", " ", names(.)[3:length(.)])) %>%
            kable(escape=F, align = 'c') %>%
            kable_styling(c("bordered"),full_width = F) %>%
            column_spec(1:2, bold = T) %>%
            add_header_above(upper_header) %>%
            collapse_rows(columns = 1, valign = 'middle')
        ),
        tags$script("
                        $('#historico-comp_table thead tr:eq(1) th:first').css('border-right', 'hidden');
                        $('.updiag').parent().css('background', '#c5c5c5');
                        $('.lowdiag').parent().css('background', '#eae7e7');
                        $('.diag').parent().css('outline', '3px solid #8b8b8b').css('outline-offset', '-3px');
                        $('.updiag').parent().hover(
                            function(){ $('.lowdiag').parent().css('opacity','0.2') },
                            function(){ $('.lowdiag').parent().css('opacity','1') }
                          );
                        $('.lowdiag').parent().hover(
                            function(){ $('.updiag').parent().css('opacity','0.2') },
                            function(){ $('.updiag').parent().css('opacity','1') }
                          );

                      "
        ),
        h5(
          ifelse(
            comp_top_rentaveis,
            "As células da diagonal superior, cinza escuro, correspondem à diferença do valor da fazenda para as top-rentáveis, em cada combinação de safra. A diagonal propriamente dita, marcada com bordas mais escuras, correspondem a comparação para a mesma safra entre fazenda e top-rentáveis. As células da diagonal inferior, cinza claro, correspondem a comparações dos valores da variável entre as safras para a própria fazenda ativa. Diferenças desejáveis são apresentadas em verde ao passo que indesejáveis em vermelho.",
            "Cada célula correponde a diferença dos valores obtidos pela fazenda entre safras. Diferenças desejáveis são apresentadas em verde ao passo que indesejáveis em vermelho."))
      )
      
    }
    # }
    
  })
  
  
  
  return(
    list(
      input = reactive({input})
    )
  )
  
}



