calc_engorda <- function(data) {

  data %>%
    mutate(resultado_total = area*resultado) %>%
    mutate(ganho_total = peso_abate - peso_entrada,
           peso_arroba = peso_abate*rendimento/100/15,
           ganho_total_arroba = peso_arroba - (peso_entrada/30),
           valor_venda_cabeca = peso_arroba * valor_medio_de_venda,
           reposicao_cabeca = reposicao * peso_entrada) %>%
    mutate(
      tempo = ganho_total/gmd/30.4,#375,
      taxa_de_abate = 12/tempo,
      desembolso_boi = tempo*desembolso,
      desembolso_arroba = desembolso_boi/ganho_total_arroba,
      resultado_boi = valor_venda_cabeca-reposicao_cabeca-desembolso_boi,
      bois_a_abater = resultado_total/resultado_boi,
      rebanho_medio = bois_a_abater/taxa_de_abate,
      lotacao_cab = rebanho_medio/area,
      lotacao_ua = (peso_abate+peso_entrada)/2/450*lotacao_cab,
      resultado_arroba = valor_medio_de_venda-desembolso_arroba,
      lucratividade_arroba = resultado_arroba/valor_medio_de_venda,
      desembolso_vmv = desembolso_arroba/valor_medio_de_venda,
      faturamento_total = bois_a_abater*valor_venda_cabeca,
      desembolso_anual = rebanho_medio*desembolso*12,
      desembolso_reposicao = bois_a_abater*reposicao_cabeca,
      producao_a_ha = ganho_total_arroba/tempo*12*lotacao_cab
    )

}


