# Module UI

#' @title   mod_q_perdeu_ui and mod_q_perdeu_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_q_perdeu
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_q_perdeu_ui <- function(id){
  ns <- NS(id)
  ui <- uiOutput(ns('ropse'))
}

# Module Server

#' @rdname mod_q_perdeu
#' @export
#' @keywords internal

mod_q_perdeu_server <- function(input, output, session, banco, get_data, configuracoes, sel_one){
  ns <- session$ns
  
  callModule(mod_bread_crumbs_server, 'bread_q_perdeu', configuracoes, banco)
  
  output$desembolso <- reactive({
    
    indicador <- 'DESEMBOLSO CAB/MÊS'
    
    ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
    
    banco$ind_top %>% filter(INDICADOR == indicador) -> config_var
    
    domain <- ref_var %>% select(min, q25, q50, q75, max) %>% unlist %>% as.vector
    referencia <- ref_var$ref
    bt_value <- 1
    valor_fazenda <- banco$fazenda %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra) %>% pull(VALOR)
    
    if(config_var$TOP == 'MENOR') {
      
      bt_value <- 0
      domain <- rev(domain)
      
    }
    
    list(
      label = "Desembolso",
      unidade = "R$/cab/mês",
      value = valor_fazenda, 
      domain = domain, 
      entity = list(id = "fazenda", label = "Fazenda", value = valor_fazenda),
      reference = list(id = 'reference', label = "Referência", value = referencia),
      bt = bt_value, 
      casas = config_var %>% pull(casas)
    ) %>% 
      toJSON(auto_unbox = T,digits = NA)
    
    
  })
  
  output$gmd <- reactive({

    indicador <- 'GMD GLOBAL (Kg)'
    
    ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
    
    banco$ind_top %>% filter(INDICADOR == indicador) -> config_var
    
    domain <- ref_var %>% select(min, q25, q50, q75, max) %>% unlist %>% as.vector
    referencia <- ref_var$ref
    bt_value <- 1
    valor_fazenda <- banco$fazenda %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra) %>% pull(VALOR)
    
    if(config_var$TOP == 'MENOR') {
      
      bt_value <- 0
      domain <- rev(domain)
      
    }
    
    list(
      unidade = 'kg/dia',
      label = "GMD", 
      value = valor_fazenda, 
      domain = domain, 
      entity = list(id = "fazenda", label = "Fazenda", value = valor_fazenda),
      reference = list(id = 'reference', label = "Referência", value = referencia),
      bt = bt_value, 
      casas = config_var %>% pull(casas)
    ) %>% 
      toJSON(auto_unbox = T,digits = NA)
    
  })
  
  output$venda <- reactive({
    
    indicador <- 'VALOR MÉDIO DE VENDA'
    
    ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
    
    banco$ind_top %>% filter(INDICADOR == indicador) -> config_var
    
    domain <- ref_var %>% select(min, q25, q50, q75, max) %>% unlist %>% as.vector
    referencia <- ref_var$ref
    bt_value <- 1
    valor_fazenda <- banco$fazenda %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra) %>% pull(VALOR)
    
    if(config_var$TOP == 'MENOR') {
      
      bt_value <- 0
      domain <- rev(domain)
      
    }
    
    list(
      label = "VMV", 
      unidade = "R$/@",
      value = valor_fazenda, 
      domain = domain, 
      entity = list(id = "fazenda", label = "Fazenda", value = valor_fazenda),
      reference = list(id = 'reference', label = "Referência", value = referencia),
      bt = bt_value, 
      casas = config_var %>% pull(casas)
    ) %>% 
      toJSON(auto_unbox = T,digits = NA)
    
  })
  
  output$lotacao <- reactive({
    
    indicador <- 'LOTAÇÃO GLOBAL UA/HA'
    
    ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
    
    banco$ind_top %>% filter(INDICADOR == indicador) -> config_var
    
    domain <- ref_var %>% select(min, q25, q50, q75, max) %>% unlist %>% as.vector
    referencia <- ref_var$ref
    bt_value <- 1
    valor_fazenda <- banco$fazenda %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra) %>% pull(VALOR)
    
    if(config_var$TOP == 'MENOR') {
      
      bt_value <- 0
      domain <- rev(domain)
      
    }
    
    list(
      label = "LOTAÇÃO",
      unidade = "UA/HA",
      value = valor_fazenda, 
      domain = domain, 
      entity = list(id = "fazenda", label = "Fazenda", value = valor_fazenda),
      reference = list(id = 'reference', label = "Referência", value = referencia),
      bt = bt_value, 
      casas = config_var %>% pull(casas)
    ) %>% 
      toJSON(auto_unbox = T,digits = NA)
    
  })
  
  output$ropse_gauge <- reactive({
    
    indicador <- 'RESULTADO OPERAÇÃO PECUÁRIA (R$/HA) SE'
    
    ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
    
    banco$ind_top %>% filter(INDICADOR == indicador) -> config_var
    
    domain <- ref_var %>% select(min, q25, q50, q75, max) %>% unlist %>% as.vector
    referencia <- ref_var$ref
    bt_value <- 1
    valor_fazenda <- banco$fazenda %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra) %>% pull(VALOR)
    
    if(config_var$TOP == 'MENOR') {
      
      bt_value <- 0
      domain <- rev(domain)
      
    }
    
    list(
      label = "RESULTADO", 
      unidade = "R$/ha",
      value = valor_fazenda, 
      domain = domain, 
      entity = list(id = "fazenda", label = "Fazenda", value = valor_fazenda),
      reference = list(id = 'reference', label = "Referência", value = referencia),
      bt = bt_value, 
      casas = config_var %>% pull(casas)
    ) %>% 
      toJSON(auto_unbox = T,digits = NA)
    
  })
  
  
  observeEvent(sel_one$processar, {
    print("EVENTO QUE PERDEU")
    updateSelectInput(session, "safra", selected = NULL)
  })
  
  
  
  output$sel_safra <- renderUI({
  
    fluidRow(
      column(6, style = 'margin-top: 50px;',
             selectInput(inputId=ns("safra"), label="Safra:", 
                         choices = get_data$rref()$data_ropse %>%
                           arrange(desc(safra)) %>% 
                           pull(safra))
      ),
      tags$div(class="col-xs-12 col-sm-6", style = 'margin-top:50px; text-align:right;', mod_bread_crumbs_ui(ns('bread_q_perdeu')))
    )  
    
    
  })
  
  output$gauges_ind <- renderUI({
    if(!is.null(input$safra)) {
      fluidPage( 
        fluidRow(
          tags$div(
            style = 'margin-top:15px',
            tags$div(id="desembolso", class="text-center col-xs-12 col-sm-6 col-md-3",
                     lapiGaugeOutput(id=ns('desembolso'), height = 150, width = 150)),
            tags$div(id="gmd", class="text-center col-xs-12 col-sm-6 col-md-3",
                     lapiGaugeOutput(id=ns('gmd'), height = 150, width = 150)),
            tags$div(id="venda", class="text-center col-xs-12 col-sm-6 col-md-3",
                     lapiGaugeOutput(id=ns('venda'), height = 150, width = 150)),
            tags$div(id="lotacao", class="text-center col-xs-12 col-sm-6 col-md-3",
                     lapiGaugeOutput(id=ns('lotacao'), height = 150, width = 150))
          )
        )
      )  
    }
  })
  
  
  output$gauge_ropse <- renderUI({
    
    if(!is.null(input$safra)){
      
      if(input$safra %in% banco$fazenda$safra) {
        
        indicador <- 'RESULTADO OPERAÇÃO PECUÁRIA (R$/HA) SE'
        
        ref_var <- banco$regua %>% filter(INDICADOR == indicador) %>% filter(safra == input$safra)
        
        get_data$rref()$data_ropse %>% filter(safra == input$safra) -> ropse_comp
        
        diff_ref <- round(ropse_comp$ropse_faz - ref_var$ref, 2)
        diff_calc <- round(ropse_comp$ropse_faz - ropse_comp$int_media, 2)
        
        col_neg <- "#f95036"
        col_pos <- "#32965d"
        
        val_top_rentaveis <- tags$span(style = paste0('color:',ifelse(diff_ref < 0, col_neg, col_pos)), ifelse(diff_ref<0, 'menos', 'mais'))
        val_esperado <- tags$span(style = paste0('color:',ifelse(diff_calc < 0, col_neg, col_pos)), ifelse(diff_calc<0, 'menos', 'mais'))
        
        fluidPage(
          fluidRow(
            column(6,
                   tags$div(
                     style = 'padding:20px; margin-top:70px;',
                     h4(style = 'font-weight:600',
                        "A fazenda gerou", val_top_rentaveis, "resultado do que as top-rentáveis."
                     ),
                     h5(
                       ifelse(diff_ref<0,
                              glue(
                                "Em relação às fazendas top-rentáveis similares, a fazenda deixou de ganhar {abs(diff_ref)} R$/ha."
                              ),
                              glue(
                                "Em relação às fazendas top-rentáveis similares, a fazenda ganhou {abs(diff_ref)} R$/ha a mais."
                              )
                       )
                     ),
                     hr(),
                     h4(style = 'font-weight:600',
                        "A fazenda gerou", val_esperado, "resultado do que o esperado."
                     ),
                     h5(
                       ifelse(diff_calc<0,
                              glue(
                                "Em relação ao resultado esperado em função dos valores de desembolso, ganho médio global, lotação e valor médio de venda mensurados, a fazenda deixou de ganhar {abs(diff_calc)} R$/ha."
                              ),
                              glue(
                                "Em relação ao resultado esperado em função dos valores de desembolso, ganho médio global, lotação e valor médio de venda mensurados, a fazenda gerou {abs(diff_calc)} R$ a mais por hectare."
                              )
                       )
                     )
                   )
            ),
            column(width=6, 
                   tags$div(id="ropse_gauge_ui", class="text-center", style = 'max-width:450px',
                            lapiGaugeOutput(id=ns('ropse_gauge'), height = 150, width = 150))
            )
          )
        )  
      }
    }
    
  })


  
  output$placar_table <- renderUI({
    
    placar <- tibble()  
    if(!is.null(banco$regua) && !is.null(input$safra)){
      banco$regua %>% 
        select(-data) %>% 
        filter(safra == input$safra) %>% 
        right_join(
          banco$fazenda %>% select(safra, INDICADOR, FRENTE, fazenda = VALOR), by = c('INDICADOR', 'safra', 'FRENTE')
        ) %>% 
        left_join(
          banco$ind_top 
        ) %>% 
        filter(!is.na(min), !is.na(fazenda)) -> placar
    }
    if(nrow(placar) > 0){
        tagList(
          h4("Placar da Safra", style = 'font-weight:600; margin-top:40px;'),
          tags$hr(style='margin-top:0px; border: 1px solid #dddddd;'),
          HTML(
            # banco$regua %>% 
            #   select(-data) %>% 
            #   filter(safra == input$safra) %>% 
            #   right_join(
            #     banco$fazenda %>% select(safra, INDICADOR, FRENTE, fazenda = VALOR), by = c('INDICADOR', 'safra', 'FRENTE')
            #   ) %>% 
            #   left_join(
            #     banco$ind_top 
            #   ) %>% 
            #   filter(!is.na(min), !is.na(fazenda)) %>% 
            placar %>%  mutate(color = ifelse(fazenda>ref, 1, -1), 
                     color = ifelse(TOP == "MAIOR",color*(-1), color),
                     color = ifelse(color == 1, 'lightblue', 'lightred')) %>% 
              mutate(variacao = (((fazenda-ref)/ref)*100) %>% digits(., 2)) %>% 
              mutate(
                fazenda = purrr::pmap_chr(
                  .l = list(fazenda, casas, unidade), 
                  .f = function(x, casas, unidade) {
                    # print(x)#format(round(ifelse(unidade == "%", x*100, x), digits=casas), nsmall = casas, digits = casas))
                    format(round(ifelse(unidade == "%", x*100, x), digits=casas), nsmall = casas, digits = casas)
                  }),
                ref = purrr::pmap_chr(
                  .l = list(ref, casas, unidade), 
                  .f = function(x, casas, unidade) {
                    format(ifelse(unidade == "%", x*100, x), nsmall = casas, digits = casas)
                  }),
                variacao = purrr::pmap_chr(
                  .l = list(variacao, casas, unidade), 
                  .f = function(x, casas, unidade) {
                    format(x, nsmall = casas, digits = casas)
                  })
              ) %>% 
              select(FRENTE, INDICADOR, UNIDADE = unidade, FAZENDA = fazenda, REFERÊNCIA = ref, VARIAÇÃO = variacao)%>%
              filter(FRENTE != "AGRICULTURA") %>% 
              arrange(FRENTE, INDICADOR) %>% 
              kable(escape=F) %>% 
              kable_styling(c("hover"),full_width = F) %>% 
              column_spec(1:2, bold = T) %>% 
              collapse_rows(columns = 1, valign = 'middle')
          )
        )
      }
      
    #}
    
  })
  
  
  # saida <- reactive({
  #   
  #   isolate({
  #     if(!is.null(input$safra)){
  #       
  #       if(input$safra %in% banco$fazenda$safra){
  #         
  #         tagList(
  #           
  #         )
  #       }
  #     }  
  #   })
  #   
  # })
  
  output$ropse <- renderUI({
    
    get_data$criar_bd_referencia()
    
    fluidPage(
      uiOutput(ns('sel_safra')),
      uiOutput(ns('gauges_ind')),
      uiOutput(ns('gauge_ropse')),
      uiOutput(ns('placar_table'))    
    )
    
  })
  
  return(
    list(
      input = reactive({input})
    )
  )
  
}

