
bullet_chart_geral<-function(df,innerwidth=4,outerwidth=10){
  p<-list()
  for(i in 1:nrow(df)){
    #i<-1
    attach(df[i,])
    
    p[[i]] <-
      
      # max
      plot_ly() %>%
      add_segments(x = as.numeric(min),
                   xend = as.numeric(max),
                   y = title,
                   yend = title,
                   name = "max",
                   text=paste("Max:",round(as.numeric(max),4)),
                   hoverinfo="text",
                   line = list(color = "#dee774", width = outerwidth)) %>%
      
      # qrt3
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt3),
                   y = title,
                   yend = title,
                   text=paste("Q75%:",round(as.numeric(qrt3),4)),
                   hoverinfo="text",
                   line = list(color = "#c5d86c", width = outerwidth)) %>%
      
      # mediana
      add_segments(x = as.numeric(min),
                   xend = as.numeric(mediana),
                   y = title,
                   yend = title,
                   text=paste("Mediana:",round(as.numeric(mediana),4)),
                   hoverinfo="text",
                   line = list(color = "#a5c86d", width = outerwidth)) %>%
      
      # qrt1
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt1),
                   y = title,
                   yend = title,
                   text=paste("Q25%:",round(as.numeric(qrt1),4)),
                   hoverinfo = "text",
                   line = list(color = "#83a55b", width = outerwidth)) %>%
      
      # min
      add_segments(x = as.numeric(min),
                   xend = as.numeric(min),
                   y = title,
                   yend = title,
                   text=paste("Min:",round(as.numeric(min),4)),
                   hoverinfo = "text",
                   line = list(color = "#666666", width = outerwidth)) %>%
      
      # 
      # # fazenda
      # add_segments(x = 0,
      #              xend = as.numeric(fazenda),
      #              y = title,
      #              yend = title,
      #              hoverinfo = "x",
      #              line = list(color = "#b0c4de", width = innerwidth)) %>%
      
      # top10
    add_markers(x = as.numeric(top10),
                y = title,
                text=paste("Top10:",round(as.numeric(top10),4)),
                hoverinfo = "text",
                marker = list(color = "#ff6a6a", symbol = "diamond-tall", size = 14,opacity=.8)) %>%
      
      layout(showlegend = F,margin=list(l=200,t=40,b=20,r=15,pad=0),
             xaxis = list(title = "", showgrid = F, zeroline = F, position=.1,
                          range = c((as.numeric(min)), as.numeric(max)),
                          ticklen = 6, ticks='inside',
                          tickfont = list(family = "Arial", size = 9),
                          tickcolor = "#cccccc",fixedrange=T),
             
             yaxis = list(title = "",
                          showgrid = F,
                          zeroline = F,
                          showticklabels = F,fixedrange=T))
    
    detach(df[i,])
  }
  
  pp <- subplot(p, nrows = length(p), margin = c(0,0,0,0))
  100/nrow(df)/100->passo
  passo_atual<-0.96
  bullet_list<-list()
  for (i in 1:nrow(df)){
    bullet_list[[i]]<-     list(xref = "paper", yref = "paper",
                                x = 0, y = passo_atual, ax = 0, ay = 0, xanchor = "right",
                                text = paste0("<b>", df[i,"title"], "</b>","<br>",
                                              '<span style = "color:grey; font-size:75%">',
                                              df[i,"subtitle"], "</span>"),
                                align = "right",
                                font = list(family = "arial",
                                            size = 10))
    passo_atual<-passo_atual-passo
  }
  
  # Add Y-Axis titles
  pp <- layout(pp, annotations = bullet_list)
  return(pp)
}

bullet_chart_fazenda<-function(df,innerwidth=4,outerwidth=10){
  p<-list()
  for(i in 1:nrow(df)){
    #i<-1
    attach(df[i,])
    
    p[[i]] <-
      
      # max
      plot_ly() %>%
      add_segments(x = as.numeric(min),
                   xend = as.numeric(max),
                   y = title,
                   yend = title,
                   name = "max",
                   text=paste("Max:",round(as.numeric(max),4)),
                   hoverinfo="text",
                   line = list(color = "#dee774", width = outerwidth)) %>%
      
      # qrt3
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt3),
                   y = title,
                   yend = title,
                   text=paste("Q75%:",round(as.numeric(qrt3),4)),
                   hoverinfo="text",
                   line = list(color = "#c5d86c", width = outerwidth)) %>%
      
      # mediana
      add_segments(x = as.numeric(min),
                   xend = as.numeric(mediana),
                   y = title,
                   yend = title,
                   text=paste("Mediana:",round(as.numeric(mediana),4)),
                   hoverinfo="text",
                   line = list(color = "#a5c86d", width = outerwidth)) %>%
      
      # qrt1
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt1),
                   y = title,
                   yend = title,
                   text=paste("Q25%:",round(as.numeric(qrt1),4)),
                   hoverinfo = "text",
                   line = list(color = "#83a55b", width = outerwidth)) %>%
      
      # min
      add_segments(x = as.numeric(min),
                   xend = as.numeric(min),
                   y = title,
                   yend = title,
                   text=paste("Min:",round(as.numeric(min),4)),
                   hoverinfo = "text",
                   line = list(color = "#666666", width = outerwidth)) %>%
      
      # fazenda
      add_segments(x = 0,
                   xend = as.numeric(fazenda),
                   y = title,
                   yend = title,
                   text=paste("Fazenda:",round(as.numeric(fazenda),4)),
                   hoverinfo = "text",
                   line = list(color = "#3c4e27", width = innerwidth)) %>%
      
      # top10
      add_markers(x = as.numeric(top10),
                  y = title,
                  text=paste("Top10:",round(as.numeric(top10),4)),
                  hoverinfo = "text",
                  marker = list(color = "#ff6a6a", symbol = "diamond-tall", size = 16,opacity=.8)) %>%
      
      layout(showlegend = F,margin=list(l=200,t=40,b=20,r=15,pad=0),
             xaxis = list(title = "", showgrid = F, zeroline = F, position=.1,
                          range = c((as.numeric(min)), as.numeric(max)),
                          ticklen = 6, ticks='inside',
                          tickfont = list(family = "Arial", size = 9),
                          tickcolor = "#cccccc",fixedrange=T),
             
             yaxis = list(title = "",
                          showgrid = F,
                          zeroline = F,
                          showticklabels = F,fixedrange=T))
    
    detach(df[i,])
  }
  
  pp <- subplot(p, nrows = length(p), margin = c(0,0,0,0))
  100/nrow(df)/100->passo
  passo_atual<-0.88
  bullet_list<-list()
  for (i in 1:nrow(df)){
    bullet_list[[i]]<-     list(xref = "paper", yref = "paper",
                                x = 0, y = passo_atual, ax = 0, ay = 0, xanchor = "right",
                                text = paste0("<b>", df[i,"title"], "</b>","<br>",
                                              '<span style = "color:grey; font-size:75%">',
                                              df[i,"subtitle"], "</span>"),
                                align = "right",
                                font = list(family = "arial",
                                            size = 10))
    passo_atual<-passo_atual-passo
  }
  
  # Add Y-Axis titles
  pp <- layout(pp, annotations = bullet_list)
  return(pp)
}

bullet_chart_resposta<-function(df,innerwidth=4,outerwidth=10){
  p<-list()
  for(i in 1:nrow(df)){
    #i<-1
    attach(df[i,])
    
    p[[i]] <-
      
      # max
      plot_ly() %>%
      add_segments(x = as.numeric(min),
                   xend = as.numeric(max),
                   y = title,
                   yend = title,
                   name = "max",
                   text=paste("Max:",round(as.numeric(max),4)),
                   hoverinfo="text",
                   line = list(color = "#dee774", width = outerwidth)) %>%
      # qrt3
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt3),
                   y = title,
                   yend = title,
                   text=paste("Q75%:",round(as.numeric(qrt3),4)),
                   hoverinfo="text",
                   line = list(color = "#c5d86c", width = outerwidth)) %>%
      
      # mediana
      add_segments(x = as.numeric(min),
                   xend = as.numeric(mediana),
                   y = title,
                   yend = title,
                   text=paste("Mediana:",round(as.numeric(mediana),4)),
                   hoverinfo="text",
                   line = list(color = "#a5c86d", width = outerwidth)) %>%
      
      # qrt1
      add_segments(x = as.numeric(min),
                   xend = as.numeric(qrt1),
                   y = title,
                   yend = title,
                   text=paste("Q25%:",round(as.numeric(qrt1),4)),
                   hoverinfo = "text",
                   line = list(color = "#83a55b", width = outerwidth)) %>%
      
      # min
      add_segments(x = as.numeric(min),
                   xend = as.numeric(min),
                   y = title,
                   yend = title,
                   text=paste("Min:",round(as.numeric(min),4)),
                   hoverinfo = "text",
                   line = list(color = "#666666", width = outerwidth)) %>%
      
      # fazenda
      add_segments(x = as.numeric(int_low),
                   xend = as.numeric(int_high),
                   y = title,
                   yend = title,
                   # text=paste("Pred.min:",round(as.numeric(fazenda)),4),
                   hoverinfo = "x",
                   line = list(color = "#3c4e27", width = innerwidth)) %>%
      
      # top10
      add_markers(x = as.numeric(top10),
                  y = title,
                  text=paste("Top10:",round(as.numeric(top10),4)),
                  hoverinfo = "text",
                  marker = list(color = "#ff6a6a", symbol = "diamond-tall", size = 16,opacity=.8)) %>%
      
      # top10
      add_markers(x = as.numeric(media_boot),
                  y = title,
                  text=paste("Pred.Med.:",round(as.numeric(media_boot),4)),
                  hoverinfo = "text",
                  marker = list(color = "#ff6a6a", symbol = 25, size = 16,opacity=.8)) %>%
      
      layout(showlegend = F,margin=list(l=200,t=40,b=20,r=15,pad=0),
             xaxis = list(title = "", showgrid = F, zeroline = F, position=.1,
                          range = c((as.numeric(min)), as.numeric(max)),
                          ticklen = 6, ticks='inside',
                          tickfont = list(family = "Arial", size = 9),
                          tickcolor = "#cccccc",fixedrange=T),
             
             yaxis = list(title = "",
                          showgrid = F,
                          zeroline = F,
                          showticklabels = F,fixedrange=T))
    
    detach(df[i,])
  }
  
  pp <- subplot(p, nrows = length(p), margin = c(0,0,0,0))
  100/nrow(df)/100->passo
  passo_atual<-0.6
  bullet_list<-list()
  for (i in 1:nrow(df)){
    bullet_list[[i]]<-     list(xref = "paper", yref = "paper",
                                x = 0, y = passo_atual, ax = 0, ay = 0, xanchor = "right",
                                text = paste0("<b>", df[i,"title"], "</b>","<br>",
                                              '<span style = "color:grey; font-size:75%">',
                                              df[i,"subtitle"], "</span>"),
                                align = "right",
                                font = list(family = "arial",
                                            size = 10))
    passo_atual<-passo_atual-passo
  }
  
  # Add Y-Axis titles
  pp <- layout(pp, annotations = bullet_list)
  return(pp)
}
