go_login <- function(redirect_url, session){
  
  if(session$clientData$url_port != "") {
    port <- paste0(":", session$clientData$url_port)
  } else {
    port <- ""
  }
  
  redirect_url <- paste0(session$clientData$url_protocol, "//", session$clientData$url_hostname, port, session$clientData$url_pathname)
  
  runjs(
    paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
  )  
}

get_url<-function(url,token){
  # set_config(config(ssl_verifypeer = 0L))
  return(content(GET(url = url,add_headers(Authorization =  paste0("Bearer ",token))),as = 'text'))
}

get_user<-function(token){
  get_url(url='https://www.inttegra.com/api/usuario',token=token)
}

AuthCode  <- function(session){
  pars <- parseQueryString(session$clientData$url_search)
  if(length(pars$token) > 0){
    return(pars$token)
  }
}