library(shiny)
library(dplyr)
library(tidyr)
library(magrittr)
library(plotly)
library(parcoords)
library(DT)
library(shinyBS)
library(shinyjs)
library(purrr)
library(jsonlite)
source("check_user.R")
source("funcoes_auxiliares.R")
source("bullet_charts.R")
source("log.R")



server<-function(input, output,session) {
  logwriter = get_log_writer("paralelas")
  # Verificar usuario -------------------------------------------------------
  acesso <- reactiveValues()
  acesso[['permissao']] <- F#Sys.getenv("APPS_INTTEGRA_DEVELOPMENT") != ""
  
  logon_info<-reactiveValues()
  
  shiny::onSessionEnded(function(){
    tout <- get_date_time()
    
    if(isolate(acesso[['permissao']]) == T && !is.null(isolate(logon_info[['usuario']])) ){
    
      write.table(isolate({
        list(
	  nome =  ifelse(is.null(logon_info$usuario$nome), "", logon_info$usuario$nome), 
          franquia = ifelse(is.null(logon_info$usuario$franquia), "", logon_info$usuario$franquia), 
          id_franquia = ifelse(is.null(logon_info$usuario$id_franquia), "", logon_info$usuario$id_franquia), 
          email = ifelse(is.null(logon_info$usuario$email),"",logon_info$usuario$email),
          logindate = logon_info$login$data, logintime = logon_info$login$hora,
          logoutdate = tout$data, logouttime = tout$hora
        )
      }), file=paste0("log/paralelas",format(Sys.Date(), "%Y"),".csv"), append = T, col.names = F, row.names=F, sep=";")
      
    }
  })
 
  observeEvent(session,{
    if(!acesso$permissao){
      AuthCode(session)->token
      if(is.null(token)){
        go_login("paralelas", session)
      } else {
        
        tryCatch({
          # usuario<-fromJSON(get_user(token))
          usuario<-fromJSON(system(paste('curl -k -H "Authorization: bearer', token,'" https://www.inttegra.com/api/usuario'),intern=T))
        },error=function(e){
	  runjs(paste("console.log(",e,")"))
          runjs(paste("alert('","Erro ao buscar dados do usuário. Contacte o desenvolvedor.",e,"')"))
          stopApp()
        })
        
        if(!is.null(usuario$nome)){
          # runjs("console.log('pegou usuario')")
          acesso[['permissao']]<-T
          logon_info[['usuario']]<-usuario
          
          logon_info[['login']] <- get_date_time()
        }
      }
    }else{
      acesso[['permissao']]<-T
      logon_info[['usuario']]<-list()
      
      logon_info[['login']] <- get_date_time()
    }
  })  
  

  
  # Carregar bancos ---------------------------------------------------------
  load('bd/modelos_cluster_sistema.rData')
  banco<-reactiveValues()
  names(clusters_boot)<-sapply(names(clusters_boot),rm_crter)
  clusters_boot %>% 
    filter(!sapply(boot_simu,is.null)) -> banco[['dados']]
  banco[['sistema']]<-NULL
  
  # Geracao de UIs ----------------------------------------------------------
  output$tela_geral<-renderUI({
    if(acesso$permissao){
      fluidRow(
        column(3,
               tags$div(id='sel_sistema_ui',
                        h4(tags$b("Sistema"),style='color:#827f7f; margin: 20px 0px 0px 10px;'),
                        hr(style='    margin: 10px 5px 10px 5px;border: 2px solid #efeeee;'),
                        tags$div(class='var_ind',
                                 selectInput(inputId = "sel_sistema",label = "Selecione um sistema:",  choices = c("Clique para selecionar" = "",sort(unique(banco$dados$sistemapecuria))),width = '300px')
                        )
               )
        ),
        column(12,
               uiOutput("paralelas_ui")
        )
      )
    } else {
      NULL
    }
  })
      
       
  
  output$paralelas_ui<-renderUI({
    fluidRow(
      column(12,
             parcoordsOutput("paralelas_bruta",height = '500px')       
      ),
      
      fluidRow(id='paralelas_mean_deviation_ui',
        column(12, align='center',style='height:100px;',
               tableOutput("paralelas_mean_p1")       
        ),
        column(12, align='center',style='height:100px;',
               tableOutput("paralelas_mean_p2")       
        )  
      )
      
    )
  })

  # Observers ---------------------------------------------------------------
  
  observeEvent(input$sel_sistema,{
    if(input$sel_sistema!=""){
      banco[['sistema']]<-input$sel_sistema
      banco$dados %>% 
        filter(sistemapecuria==banco$sistema) %>% 
        unnest(data)->d1
      
      banco[['labels']]<-tibble(original=names(d1),p_analise=sapply(names(d1),rm_crter))
      names(d1)<-sapply(names(d1),rm_crter)
      banco[['dados_sistema']]<-d1
      # get_k_means()
      # get_summary()
    } else {
      banco[['sistema']]<-NULL
    }
  })
  
  # Reativos ----------------------------------------------------------------
  
  calc_paralela_mean <- reactive({
    
    if(!is.null(input$paralelas_bruta_brushed_row_names)){
      banco[['tabela_paralelas']]->tabela_paralelas
      
      tabela_paralelas %<>% 
        slice(as.numeric(input$paralelas_bruta_brushed_row_names))
      
      tabela_paralelas %<>% 
        summarise_all(mean) %>% 
        tidyr::gather(value='media') %>% 
        left_join(
          tabela_paralelas %>% 
            summarise_all(sd) %>% 
            tidyr::gather(value='sd')
        ) %>% 
        mutate(value=paste0(round(media,2)," (",round(sd,1),")")) %>% 
        left_join(banco$labels %>% dplyr::select(key=p_analise,label=original)) %>% 
        dplyr::select('Variável'=label,Valor=value)
      
      setNames(
        data.frame(
          t(tabela_paralelas[,-1]))
        ,tabela_paralelas[,1]
      )->resp
      
      return(list(p1=resp[,1:ceiling(ncol(resp)/2)],p2=resp[,(1+ceiling(ncol(resp)/2)):ncol(resp)]))
      
    } else {
      return(NULL)
    }
  })
  

  # Geracao de plots --------------------------------------------------------

  output$paralelas_bruta <- renderParcoords({
    
    # browser()
    
    if(!is.null(banco$dados_sistema)){
      if(banco$sistema=="RECRIA-ENGORDA"){
        banco$dados_sistema %>%
          ungroup %>% 
          dplyr::select(
            resultadooperaopecuriarhase,
            valormdiodevenda,
            desembolsocabms,
            custeiofixocabms,
            gmdglobalkg,
            produoglobaldeporha,
            lotaoglobaluaha,
            agiocomprageral,
            nutriorcab,
            pastagemrcab,
            modeobrapermanentercabms,
            precipitaoanualmm,
            desembolsopecurioporhaanosemcompradegado
          ) %>% 
          as.data.frame(.) %>% 
          .[,!apply(.,2,function(x){all(is.na(x))})] %>% 
          missMDA::imputePCA(.) %>% 
          .$completeObs %>% 
          as.data.frame(.)->banco[['tabela_paralelas']]
      } else {
        banco$dados_sistema %>% 
          ungroup %>% 
          dplyr::select(
            resultadooperaopecuriarhase,
            valormdiodevenda,
            desembolsocabms,
            custeiofixocabms,
            gmdglobalkg,
            # taxadedesmamesf,
            # kgdesmamadoporvacaexpostasfkg,
            produoglobaldeporha,
            lotaoglobaluaha,
            agiocomprageral,
            nutriorcab,
            pastagemrcab,
            modeobrapermanentercabms,
            precipitaoanualmm,
            desembolsopecurioporhaanosemcompradegado
          ) %>% 
          as.data.frame(.) %>% 
          .[,!apply(.,2,function(x){all(is.na(x))})] %>% 
          missMDA::imputePCA(.) %>% 
          .$completeObs %>% 
          as.data.frame(.)->banco[['tabela_paralelas']]
      }
      
      banco$tabela_paralelas->tab_par
      names(tab_par)<-banco$labels$original[match(names(banco$tabela_paralelas),banco$labels$p_analise)]
      
      parcoords(
        margin=list(top=200,left=20,right=20,bottom=20)
        ,data = tab_par
        ,rownames = F
        # ,color = list(colorBy="RESULTADO OPERAÇÃO PECUÁRIA (R$/HA) SE")
        ,brushMode = "1D-axes",alphaOnBrushed = .15,reorderable = T,autoresize = T
        ,tasks = list(
          'function(){
          d3.select(this.el).selectAll(".dimension:nth-child(n+1) > .axis > text")
          //translate down and to right assuming will need more room
          //     but this might remove our handle for reorderable if brush is on
          //rotate -90 so vertical, but -45 might be better with translate(-5,-5)
          .attr("transform","translate(10,10) rotate(-90)");

          d3.select(this.el).selectAll(".dimension:nth-child(n+1) > .axis > text").style("font-size","12px").style("text-shadow","2px 2px 10px #b2b2b2").style("align","right");
    }'
        )
        )
      
  } else {
    NULL
  }
})
  
  output$paralelas_mean_p1 <- renderTable(spacing='xs',width='80%',{
    if(!is.null(input$paralelas_bruta_brushed_row_names)){
      calc_paralela_mean()$p1
    } else {
      NULL
    }
  })
  
  output$paralelas_mean_p2<-renderTable(spacing='xs',width='80%',{
    if(!is.null(input$paralelas_bruta_brushed_row_names)){
      calc_paralela_mean()$p2
    } else {
      NULL
    }
  })
  
}
