var Ampulheta = function(){
    var width = 16;
    var height = 30;
    var top = 0;
    var duration = 1000;
    function main(selection){
        selection.each(function(d,i){
            var g = d3.select(this);
            if (g.selectAll('.ampulheta').empty())
            {
                g.append('polygon').attr('points',_ampulheta(16,height,0,top))
                .attr('class','ampulheta');
            }
            g.selectAll('.ampulheta').transition().duration(duration)
            
            .attr('points',_ampulheta(16,height,d,top));
        });
        
        
    }

    main.height = function(_){
        return (arguments.length) ? (height=_, main) : height;
    };

    main.width = function(_){
        return (arguments.length) ? (width=_, main) : width;
    };
    main.top = function(_){
        return (arguments.length) ? (top=_, main) : top;
    };

    main.duration = function(_){
        return (arguments.length) ? (duration=_, main) : duration;
    };

    return main;
}

function _ampulheta(w,h,x=0,z){
    var retorno = [];
    var a = w/2;
    retorno[0] = [x-a,z];
    retorno[1] = [x+a,z];
    retorno[2] = [x, z+h/2];
    retorno[3] = [x+a,z+h];
    retorno[4] = [x-a,z+h];
    retorno[5] = [x, z+h/2];
    return retorno.map(function(d){ return d.join(",");}).join(" ");
}