var BulletChart = function(){
    var width = 400,
    height = 30;
    
    var ranges = bulletRanges,
    innerbar = bulletMeasures,
    losango = bulletLosango,
    innerbarRange = [0, width],
    innerbarOffset = 0,
    reverse = false,
    tickFormat = null,
    duration = 1000;

    var margin = { top: 20, left : 20};
    
    var dados = [];

    //var color = ['#e6e600','#ccff99', '#00c300','#00a100'];
    var color = ['#dee774','#c5d86c','#a5c86d','#83a55b'];
    function main(selection){
        var self = this;
        var ampulheta = Ampulheta().duration(duration);
        var losango = Losango().width(10);
		selection.each(function(d, i){
            dados = d;
            // nó raiz
            var svg = d3.select(this);

            var barLength = width - (margin.left*2);

            var barHeight = (height/3);

            var innerHeight = barHeight / 2;
            ampulheta.height(innerHeight);
            losango.height(barHeight);
            
            var legendas = svg.selectAll('g.legenda').data([dados]);
            legendas.exit().remove();
            
            l_enter = legendas.enter().append('g')
                .attr('transform','translate('+margin.left+','+(margin.top)+')').attr('class','legenda');
            l_enter.append('text').text(function(d){return d.title;}).attr('class','title');;
            
            l_enter.merge(legendas).select('text.title')
                .text(function(d){return d.title;});
            
            var backScale = d3.scaleLinear().domain([d3.min(dados.ranges), d3.max(dados.ranges)])
                .range([0,barLength]);
            
            var b_data = svg.selectAll('g.bullet').data([dados]);
        
            var bullet = b_data.enter().append('g')
            .attr('transform','translate('+margin.left+','+(margin.top*1.5)+')')
            .attr('class','bullet').merge(b_data);
            
            var gData = bullet.selectAll('rect.quartil')
            .data(dados.ranges.sort(d3.ascending).reverse());
                  
            var gEnter = gData.enter().append('rect').attr('x', 0).attr('height', barHeight)
                .attr('width',backScale)
                .attr('fill', function(d,i){return color[i];})
                .attr('class','quartil') .on("mouseover",function(d){
                    d3.select('body').append('div').style('position','absolute')
                    .style('text-align','center')
                    .attr('class','tool-tip');
                })
                .on("mousemove",function(d){
                    var self = this;
                    d3.select('.tool-tip')
                    .html(function(){
                        return Math.round((backScale.invert(d3.mouse(self)[0])*100))/100;
                    })	
                    .style("left", (d3.event.pageX + 5) + "px")		
                    .style("top", function(d){
                        return d3.event.pageY + "px";
                    });
                })
                .on("mouseout",function(){d3.select('.tool-tip').remove();});;
                
                

            gEnter.merge(gData).on("mouseout",function(){d3.select('.tool-tip').remove();}).transition().duration(duration)
            .attr('width', function(d){ 
                    return backScale(d);
            });
            if(dados.innerbar){
                var innerData = bullet.selectAll('rect.inner').data([dados.innerbar]);
                var innerScale = d3.scaleLinear().domain(backScale.domain()).range(backScale.range());
                
                    //.range([backScale(dados.innerbar[0]), backScale(dados.innerbar[1])]);
                
                var innerEnter = innerData.enter().append('rect').attr('class','inner')
                .attr('x',function(d){
                    return backScale(d[0]);
                })
                .attr('width',function(d){
                    return backScale(d[1]) - backScale(d[0]);
                })
                .attr('height', innerHeight)
                .attr('y', (barHeight/2) - innerHeight/2)
                .attr("pointer-events", "none");

                innerEnter.merge(innerData).transition().duration(duration)
                .attr('x',function(d){
                    return backScale(d[0]);
                })
                .attr('width',function(d){
                    return backScale(d[1])  - backScale(d[0]);
                });
            }
            ampulheta.top((barHeight/2) - innerHeight/2);
            if(dados.ampulheta)
            bullet.data([backScale(dados.ampulheta)]).call(ampulheta);
            bullet.data([backScale(dados.losango[0])]).call(losango);
            
            gData.exit().remove();
                // marcador losango

            
               
           
            // Compute the tick format.
        var format = tickFormat || backScale.tickFormat(8);
    
        // Update the tick groups.
        var tick_id = 0;
        
        var tick = bullet.selectAll("g.tick")
        .data(backScale.ticks(8), function(d) {
            return d.id || (d.id = ++tick_id);//this.textContent || format(d);
        });
        tick.exit().remove();
        // Initialize the ticks with the old scale, x0.
        var tickEnter = tick.enter().append("g")
            .attr("class", "tick")
            .attr("transform", bulletTranslate(function(d){ return backScale(d);}))
            .style("opacity", 1e-6);
  
        tickEnter.append("line")
            .attr("y1", height/2)
            .attr("y2", height * 7 / 6);
  
        tickEnter.append("text")
            .attr("text-anchor", "middle")
            .attr("dy", "1em")
            .attr("y", height * 7 / 6)
            .text(function(d){
                return format(d);
            });
  
        // Transition the entering ticks to the new scale, x1.
        tickEnter.transition()
            .duration(duration)
            .attr("transform", bulletTranslate(function(d){
                return backScale(d);
            }))
            .style("opacity", 1);
  
        // Transition the updating ticks to the new scale, x1.
        var tickUpdate = tickEnter.merge(tick).transition()
            .duration(duration)
            .attr("transform", bulletTranslate(function(d){
                return backScale(d);
            }))
            .style("opacity", 1);
  
        tickUpdate.select("line")
            .attr("y1", barHeight)
            .attr("y2", barHeight * 7 / 6);
  
        tickUpdate.select("text")
            .attr("y", barHeight * 7 / 6);
  
        // Transition the exiting ticks to the new scale, x1.
        tick.exit().transition()
            .duration(duration)
            .attr("transform", bulletTranslate(function(d){
                
                return backScale(d);}
            ))
            .style("opacity", 1e-6)
            .remove();
        
        });

    };
    
    main.duration = function(_){
        return (arguments.length) ? (duration=_, main) : duration;
    };

    main.losangoKey = function(_){
        return (arguments.length) ? (losangoKey=_, main) : losangoKey;
    };
    main.width = function(_){
        return (arguments.length) ? (width=_, main) : width;
    };

    main.height = function(_){
        return (arguments.length) ? (height=_, main) : height;
    };

    main.ranges = function(_){
        return (arguments.length) ? (ranges=_, main) : width;
    };

    main.dados = function(_){
        return arguments.length ? (dados=_, main) : dados;
    };

    main.innerbarRange = function(_){
        return arguments.length ? (innerbarRange=_, main) : innerbarRange;
    };

    main.innerbarOffset = function(_){
        return arguments.length ? (innerbarOffset=_, main) : innerbarOffset;
    };

    main.quartis = function(_){
        return arguments.length ? (quartis = _, this) : quartis;
    };

    main.dados = function(_){
        return arguments.length ? (dados = _, this) : dados;
    }

    return main;
};

function bulletRanges(d){
    return d.ranges;
}

function bulletLosango(d) {
    return d.losango;
  }

function bulletMeasures(d) {
    return d.innerbar;
  }

  function bulletTranslate(x) {
    return function(d) {
      return "translate(" + x(d) + ",0)";
    };
  }

function bulletWidth(x) {
    var x0 = x(0);
    return function(d) {
      return Math.abs(x(d) - x0);
    };
  }
  

