var Losango = function(){
    var height = 30;
    var width = 30;
    
    function main(selection){
        selection.each(function(d,i){
            var g = d3.select(this);
            if (g.selectAll('.losango').empty())
            {
                g.append('polygon').attr('points',_losango(width,height))
                .attr('class','losango');
            }
            g.selectAll('.losango').transition().duration(2000)
            .attr('points',_losango(width, height, d));
        });
        
        
    }

    main.height = function(_){
        return (arguments.length) ? (height=_, main) : height;
    };

    main.width = function(_){
        return (arguments.length) ? (width=_, main) : width;
    };
    return main;
}

function _losango(w, h, z=0){
    var retorno = [];
    var a = w/2;
    retorno.push([z,0]);
    retorno.push([z+a,h/2]);
    retorno.push([z,h]);
    retorno.push([z-a, h/2]);

    return retorno.map(function(d){ return d.join(",");}).join(" ");
};