#' @import shiny
#' @import shinyBS
#' @import shinythemes
#' @import shinyjs
app_ui <- function() {
  library(shinyBS)
  library(shinyjs)
  
  tagList(
    # Leave this function for adding external resources
    golem_add_external_resources(),
    # List the first level UI elements here 
    fluidPage(
      theme = shinytheme("simplex"),
      useShinyjs(),
      uiOutput("index_ui")
    )
  )
}

#' @import shiny
golem_add_external_resources <- function(){
  
  addResourcePath(
    'www', system.file('app/www', package = 'farmView')
  )
 
  tags$head(
    # golem::js(),
    golem::favicon(),
    tags$link(rel="stylesheet", type="text/css", href="www/css/lapicharts.css"),
    tags$link(rel="stylesheet", type="text/css", href="www/css/farmview_style.css"),
    # tags$link(rel="stylesheet", type="text/css", href="www/css/simple_scroll_bar.css"),
    tags$script(src="www/js/jquery.mask.min.js"),
    # tags$script(src="www/js/simple_scroll_bar.js"),
    tags$script(src="www/js/script.js"),
    tags$script("$(document).ready(function(){
    $('[data-toggle=\"tooltip\"]').tooltip(); 
    $('[data-toggle=\"popover\"]').popover(); 
});")
    # Add here all the external resources
    # If you have a custom.css in the inst/app/www
    # Or for example, you can add shinyalert::useShinyalert() here
    
  )
  
  # dep_binding()
}
