# Module UI
  
#' @title   mod_autenticacao_ui and mod_autenticacao_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_autenticacao
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_autenticacao_ui <- function(id){
  ns <- NS(id)
}
    
# Module Server
    
#' @rdname mod_autenticacao
#' @export
#' @keywords internal
    
mod_autenticacao_server <- function(input, output, session, login, logon_info){
  
  ns <- session$ns
  
  go_login <- function(redirect_url, session){
    
    redirect_url <- paste0("https://", session$clientData$url_hostname, "/", redirect_url)
    
    runjs(
      paste0('window.location.replace("https://inttegra.com/sistema/sistema.htm?l=login&redirect_uri=',redirect_url,'");')
    )  
  }
  
  get_url <- function(url,token){
    # set_config(config(ssl_verifypeer = 0L))
    return(content(GET(url = url,add_headers(Authorization =  paste0("Bearer ",token))),as = 'text'))
  }
  
  get_user <- function(token){
    get_url(url='https://www.inttegra.com/api/usuario',token=token)
  }
  
  AuthCode <- function(session){
    pars <- parseQueryString(session$clientData$url_search)
    if(length(pars$token) > 0){
      return(pars$token)
    }
  }
  
  observeEvent(session, {
    AuthCode(session) -> token
    if(!login$permissao){
      if(is.null(token)){
        go_login("farmview", session)
      } else {
        
        tryCatch({
          usuario<-fromJSON(system(paste('curl -k -H "Authorization: bearer', token,'" https://www.inttegra.com/api/usuario'),intern=T))
          
        },error=function(e){
          runjs(paste("alert('","Erro ao buscar dados do usuário. Contacte o desenvolvedor.","')"))
          stopApp()
        })
        
        if(!is.null(usuario$nome)){
          login[['permissao']] <- T
          logon_info[['usuario']] <- usuario
        }
      }
    } else {
      logon_info[['usuario']] <- list(id_franquia="622",nome='Luigi', franquia="TERRA", tipo_usuario = 'U') #1076 DSM
    }
    
  })
  
}
    
## To be copied in the UI
# mod_autenticacao_ui("autenticacao_ui_1")
    
## To be copied in the server
# callModule(mod_autenticacao_server, "autenticacao_ui_1")
 
