# Module UI
  
#' @title   mod_bread_crumbs_ui and mod_bread_crumbs_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_bread_crumbs
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_bread_crumbs_ui <- function(id){
  ns <- NS(id)
  ui <- uiOutput(ns('bread_crumbs_ui'))
}
    
# Module Server
    
#' @rdname mod_bread_crumbs
#' @export
#' @keywords internal
    
mod_bread_crumbs_server <- function(input, output, session, configuracoes, banco){
  
  ns <- session$ns

  output$bread_crumbs_ui <- renderUI({
    banco$processar  
    isolate({
      if(!is.null(banco$fazenda)){

        nome <- banco$fazenda %>% select(nome) %>% unique() %>% pull(nome)
        ag <- list('all' = 'Todas fazendas', 'sistema' = 'Sistema', 'cluster' = 'Cluster'  )
        
        crumb<-tagList(
          tagList(
            tags$strong("Fazenda:"), tags$span(nome)
          ),
          tagList(
            tags$strong("Referência:"), tags$span(ag[configuracoes$agrupamento])
          )
        )
        
        lapiBreadCrumbs(crumb)   
        
      } else {
        NULL
      }  
    })
  })

}
    
## To be copied in the UI
# mod_bread_crumbs_ui("bread_crumbs_ui_1")
    
## To be copied in the server
# callModule(mod_bread_crumbs_server, "bread_crumbs_ui_1")
 
