# Module UI
  
#' @title   mod_seletores_ui and mod_seletores_server
#' @description  A shiny Module.
#'
#' @param id shiny id
#' @param input internal
#' @param output internal
#' @param session internal
#'
#' @rdname mod_seletores
#'
#' @keywords internal
#' @export 
#' @importFrom shiny NS tagList 
mod_seletores_ui <- function(id){
  ns <- NS(id)
  ui <- uiOutput(ns("botao"))
}
    
# Module Server
    
#' @rdname mod_seletores
#' @export
#' @keywords internal
    
mod_seletores_server <- function(input, output, session, banco, logon_info, get_data, configuracoes){
  ns <- session$ns
  
  #preparando objeto de retorno
  config <- reactiveValues(
    processar = NULL,
    fazenda_sel = NULL,
    agrupamento = NULL,
    intra_franquia = NULL
    
  )
  
  # observer para atualizar objeto de retorno
  # observeEvent(input$processar, {
  #   
  #   # config$processar <- input$processar
  #   config$fazenda_sel <- input$sel_fazenda %>% as.numeric()
  #   config$agrupamento <- input$agrupamento
  #   config$intra_franquia <- input$intra_franquia
  #   
  #   banco$processar <- banco$processar + 1
  #   removeModal()
  # })
  
  observeEvent(input$sel_fazenda,{
    configuracoes$fazenda_sel <- input$sel_fazenda
  })
  observeEvent(input$agrupamento, {configuracoes$agrupamento <- input$agrupamento})
  observeEvent(input$intra_franquia, {configuracoes$intra_franquia <- input$intra_franquia})
  observeEvent(input$processar, {
    banco$processar <- banco$processar + 1
    removeModal()
  })
 
  
  create_farm_selector <- function(x) {
    
    x %>% select(nome, faz_id) %>% split(.$nome) %>% lapply(., pull, faz_id)
  }
  
  show_config_modal <- function(){
    
    showModal({
      modalDialog(title = "Configurações", easyClose = T, 
                  {
                    if(!is.null(banco$faz_id_data)) {
                      
                      if(logon_info$usuario$tipo_usuario != "U") {
                        banco_fazendas <- banco$faz_id_data %>% filter(id_franquia == logon_info$usuario$id_franquia)
                      } else {
                        banco_fazendas <- banco$faz_id_data
                      }
                      
                      banco_fazendas %>% 
                        split(.$franqueado) %>% 
                        lapply(., create_farm_selector) -> choices_fazenda
                        
                      
                      fluidPage(
                         fluidRow(
                           column(12, selectInput(inputId = ns("sel_fazenda"), label = "Fazenda", choices = choices_fazenda, selected = isolate(configuracoes$fazenda_sel)))
                         ),
                        fluidRow(
                          column(12,
                                 selectInput(
                                   inputId = ns('agrupamento'),
                                   label = 'Base de comparação',
                                   choices = list('Todas fazendas' = 'all', 'Sistema' = 'sistema', 'Cluster' = 'cluster' ),
                                   selected = isolate(configuracoes$agrupamento)
                                 )
                          )
                        ),
                        fluidRow(
                          column(12,
                                 radioButtons(
                                   inputId = ns('intra_franquia'),
                                   label = "Comparar apenas com fazendas da franquia?",
                                   choices = list('Sim' = 's', 'Não' = 'n'),
                                   selected = isolate(configuracoes$intra_franquia),
                                   inline = T
                                 )
                          )
                        )
                      )
                    }
                    
                  },
                  footer = tagList(
                    actionButton(ns('processar'),label = 'Processar'),
                    tags$button(id=ns("close-modal"), class="btn btn-danger", "data-dismiss"="modal", "Cancelar")
                    )
      )
    })
  }
  
  
  observeEvent(input$show,{
    show_config_modal()
  })

  output$botao <- renderUI({
    show_config_modal()
    actionLink(inputId = ns("show"), label="Configurações", icon=icon("cog"), class="pull-right", style="padding-top:11px")
  })
    
  

  
  
  
  observe({
    if(!is.null(input$agrupamento)){
      if ("all" %in% input$agrupamento) {
        if(which(input$agrupamento=="all")==1){
          if(length(input$agrupamento)>1){
            selected_choices<-setdiff(input$agrupamento,"all")  
            
            
          } else {
            selected_choices<-"all"  
            
          }
        } else {
          selected_choices<-"all"
          
        }
        
        updateSelectInput(session, "agrupamento", selected = selected_choices)
      } 
    }
    
    banco$agrupamento <- input$agrupamento
    
    
  })
  
  observeEvent(input$processar,{
    if(input$processar>0) {banco$processar <- banco$processar + 1}
    removeModal()
  })
  
  return(config)
  
}
    
## To be copied in the UI
# mod_seletores_ui("seletores_ui_1")
    
## To be copied in the server
# callModule(mod_seletores_server, "seletores_ui_1")
 
